#!/usr/bin/env python
#
# DataPipeline - A data import and fitting tool
# Copyright (C) 2011 Damien Farrell
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Contact information:
# Email: damien.farrell_at_ucd.ie
# Normal mail:
# Damien Farrell
# SBBS, Conway Institute
# University College Dublin
# Dublin 4, Ireland
# 

from Tkinter import *

def logo():
    img = PhotoImage(format='gif',data=
             'R0lGODlhOQFcAKUiAAAAAAAGAwALBQARCAAWCgAcDQAhDwAsFAAyFwA3GQBC'
            +'HgBNIwBTJgBYKABdKgBoLwBuMgBzNDhbijdcijhciThdik9iKAB5NwB+OQCE'
            +'PACJPgCPQQCaRgClSwCqTQCwUHeTPNfkvf//////////////////////////'
            +'////////////////////////////////////////////////////////////'
            +'/////////////////////////////////yH+EUNyZWF0ZWQgd2l0aCBHSU1Q'
            +'ACH5BAEKAD8ALAAAAAA5AVwAAAb+wJ9wSCwaj8ikcslsOp/QqHRKrVqv2Kx2'
            +'y+16v+CweEwum8/otBgAUAsllbh8Tq/b7/i8Xi4xwveAgYKAfW6GYGxtaRSD'
            +'jY6PFRNEjJCVlnWSh5pbiYpnl6ChFUSipY+bqFidnmVyH6+wsbKztLW2t7gf'
            +'cqRxub6/wLm7qcRTq6xjrsHLzMDDQsrN0tOxz8XXTcfIYdHU3s3W3d/jvtbY'
            +'50iJBp2tveTv5XG8FfD1tubo+UOJDQ7sye7sCawmb4i4gfXw6cvH7wODf9wC'
            +'IhQYTuJEeAoXnmv4QQHELwcvkqtIT2TCghoXcvyQIJGYkCa9kYyJEWVKhmwa'
            +'wPKAwCX+GJg0pc0MOi7jTWIrP3hYx+anRaLThkKlZvQoqqQfOjDdlgXoVGc2'
            +'vX4VZtPqNawfOBDwyUXsWFxS3y6ravYQ2rQD2GpxK7dW3L6/6NZ1c/fDBgF6'
            +'sfAFLOsvY7hlB1/NaUtDgMRWTGkeNG+z5zuSz1K2heFy0ywTPqu2QyT16tej'
            +'QiMdbSvCx8ywVxcymPvzbtmbCseCcBu48ePIfwiP1aB48ufQrWibTr26Np2+'
            +'HmKOYr279+/gjxkJT768+fHm06uvXmS9eey+PG534r6+fVb385/fp78/eCKJ'
            +'HCDggAQWaOCBCAoIQTAtnWaMfxBaB2CEFIrHX4UYOqgcG4/+xcLTfEwkYsGI'
            +'JJZo4okopqjiiixaoFciIMQo44w01mjjjTjmqOOLbITg449ABinkkEQWaeSR'
            +'IfAIQIcebvUgAC1GKeWUUSqp45VYZqklCEoi6eWXYHqpJJOxaAViEiJSqeaa'
            +'U1q55ZtwZtllmHTWCeaYZMKi1plHpMnmn4Ca6GachBY645x2JqpokHjm+QoH'
            +'iGkYIhuBVhrooIZmCieii3ZqZ6OOGhYpV+lQaumpamKq6apYcurpq1+CGmoG'
            +'ppGKHpSo5lqlhjCy6uuVrsIqbJGyhloan0L4qeuyKKr667OH8trjsNQSK+2S'
            +'ocpCHLLKMuvtiM5CC22w1ZZbbLb+Dzg3Ia7fthuuuL+SWy6152bb3Jndtrvs'
            +'u/CyKu+8wtab7QLqbsiuvszy26+m/wL8qsDZyifphQh/q/DChjbscKcQZ9vT'
            +'xMmaWvG+12IsrsYbK9pxqB+CnOHL674cYcwyQ7hutriYOXHNFdLMc34+/3zf'
            +'zTjf0kEBmAntX3tKAx100+oRXbQte4Ic3dXHJTI1LpAii/XXR2m9tS0eHKAk'
            +'1O7dinbUTK+9Xttj2/Ixfm7X93Td/12Id3pSxx2LxG3vvV/Igpd3d+ESXui3'
            +'LAQnlu/Ill5scpwop/zptYvDcu/OIkOOquSTv1m55XSu7Gi62z3uOaCgh67l'
            +'6KTfifn+4ttarfrqbLbueqvXxj6s6Uwea7XBuH9e8u6rwu47ksA/Riu+nRfP'
            +'+vHIZ6r88kY2D9hhfN4ufZvUV1/o9dgTqb1cHOQ1PMXfXxq++JT3Xj7Hsxdd'
            +'ta3rtu8+3QDAn7H881NZ/bKlM/zlT39/0p3/akS+AALpfFNZitcIh8AEvm+B'
            +'rwOgA+sEQaK0zIBtq2DuLohB3vFvg4nqYFAaBMIQijBVJCzhjjSIQtnxL2IT'
            +'POALwcc/GYqOhjUU0wCZpJ31lQpx5DkcErWhxCVaiHCO2lwL1ebE7jSxitfC'
            +'YuIIl6AuehFBCwJG7abYJy1ukXBmZOIVsbjG/MAnF7bJIdj+5oicn73xFsIj'
            +'Ix33yMcrLAcWlpHjEdP4RL0RUpB95A5tbME9I2bjkNNpoxMTiYhF0iJ9iCwj'
            +'JAu5yUJSkhOWlMX9tOC9HZ5IgT7M5CeXIJwCgvJgpmQRKmWoylWiKZSvkKAj'
            +'oVDKWJJoliWspS01ecdczq0LvfSli2LowxsJc5htKyZLnqlJZbYImBikJjQJ'
            +'V0yJ6ZE+0bPmKZnZTAbucpuTAsAdpfiFZPoSmwvU5jaT4g953kqcK4Kn/+w5'
            +'zJWMMQzujKU+4cdPW3LkAgXLQkBNOVDxFXSVDcnjGBa6w4ZW76Gf5McGakUG'
            +'ir7QosjDKCUTkYBRlcGjIgTp7kRDmkg1djSc+PwlOcsZrW+iU5MspWIn+bdT'
            +'m940cD6tQk8/MtRz/nSQaigqMop6VKEatalQvelTo0rVfga1qljN6hWCAAA7')
    return img
    
def formatsDiagram():
    img = PhotoImage(format='gif',data=
        'R0lGODlhigJnAef/AAABAAEEAAkCAAMGAg0GBAYJBQoMCBMODQ4QDRITEBkS'
        +'CxsSEhkWDhYYFQ0aJhkaGBweGyccGh8hHiIkIiMmGTEiHhQoPSYoJSkqKDcp'
        +'Ii0uLDAxLzI0Mh44U0gxMDI5JkM0JjU3NDY6Kjc5Njo7OUE8Ozw+Oz89QTxA'
        +'Qj9APlA/LFU8PEFDQDxESj9GM2E8OmY7PIgzNkVGRJAyMzVJY1pDMow1LYw1'
        +'Mz5JVYc3MkhKR387P5A5NmVGRUxOSypUg5Q8OWRLNk1TPJw9PVBSTzxXfFNV'
        +'UjJbijlahaFCQXZPTYJONlZYVTVdjaZEPzxdiAB9ADhfkHFXQK5GQ1xdW7VF'
        +'RjtikgCDBVdjRQCFCV9hXkBmlzlonVpoQLZMSVxpPINbWV1oTL1MTEholMRL'
        +'TmRmY0Rqm35iSMFQTyZ3l0FupcNRT2hqZ4tiYEhwm8dUTZJiYkVyqW1vbDV9'
        +'kkl1rJppR0N4tGx2VWV7Pk14sJlpaVR4oHJ0cbNoMEd7uE96sjmEmXV3dEp9'
        +'urdsLUt+u1p8pACkO2uFO06BvkiDxnp8eVCCwKVycm6IPb9yM3mDYWqLPnCK'
        +'P36AfT2QpFWHxU+JzG2PPGWGraN9XnWOQ4KEgQCwTch6NHiRP0yP2IeJhmyN'
        +'tM59OKuEY36WRISTaYyOi9eAPX2cSUehuo+RjtuDOcCFgnmXvJOVkYShR7mQ'
        +'aeOKP4ilS5eZls2LikitxX6fx5udmuqPPoSgw8aWcPGPQJeleI+tUaCinvaT'
        +'RIyny9mWlbGwCpWyVvmWR6Smo5i0Uv2ZQ96ambC2DJa4VKmrp5m8WKyuq5ay'
        +'1uqfnru+A5y/W7Gzr9+rf6e7iJy427W3tKa93Lq8uL2/vLbIjsDCv9DRAPG7'
        +'ibPG38XIxL7Qlv2/jsnLyLzQ6cTWnM7Qzf/IlMnboNLU0f/PmOPnAMXZ8tXY'
        +'1M3gpNja1snd9s/kotrc2e3vAN3f3NHh9d/i3uPl4tfvq+fp5v//Aezu6/Dz'
        +'7/X38/n79/z++/7//P///yH+EUNyZWF0ZWQgd2l0aCBHSU1QACH5BAEKAP8A'
        +'LAAAAACKAmcBAAj+AP8JHEiwoMGDCBMqXMiwocOHECNKnEixosWLGDNq3Mix'
        +'o8ePIEOKHEmypMmTKFOqXMmypcuXMGPKnEmzps2bOHPq3Mmzp8+fQIMKHUq0'
        +'qNGjSF0GWMq0adKnUFk2nRogqtWrWGkubYDBhyJJkhQZudBgwNKsaNNKXJpA'
        +'gg4+YCUx0fDAwFm1ePPqXRtAxidy/gILDnwulY67exOjXRpCkrfBg+XZYoIA'
        +'seLLmLMu1aAsH+TP/vRVY2H54RErW1KrXs26NesjAqO4nk07dRTYR2TX3r06'
        +'isDTvINvgZ254lIJsuiBhsxPm5HSCXML5x2lyb8bQ7Jr3869O3cgNwT+ZhpF'
        +'vrz58+jNn8rU6N8gR5ziy59Pvz79QcXzd1wqh9/y5fp8Ah1DR6ixCCEIJqjg'
        +'ggwmuAhxWzQo4YSELGLGE/8cYcaBFHaIoCBbCNREHBx6SOEiSOjHFxP3/Aca'
        +'P7YMaNARW5Ro4oRmwJYDGmL06OOPQAbpIxpThPfPKMkkqeSSTDa55DKntOcI'
        +'LL5UaeWVWGZ5pS59qOilRUvJ4qKLtlQW0REkLqLmmmy26SabEL4p55xqXpih'
        +'gXTmuSYhIf4zop6AovilQ0uVMeZ/2pi5EI2B6pnjdWhEKumklFZKaZECnZLM'
        +'Mpx26umnoHoa5T9TDmPqqaimqiqqvnQ56Kv+hA7AzKEuKmMXRGg2mmecus5p'
        +'Z4G9ysmniGkG62aKsCa0lCK0/kfPA1UpxKixbj56g6XYZhsppv9oGuq34EIp'
        +'JSyrlmvuMK0mqy5CS33SLJkyHpQrtW3ySu+av+J574F9/rmvmsiuW1AAbLz7'
        +'3zUJRIvQtP9aq+3DlxrpbbgUdzpqqedmfGq6Anf8TwA+GOyiJAoTWOy+9u6b'
        +'77/8EsuyoB4L1JdnIoNWSskz1siywxD3zO3EFVN8Mbkaa8xxzMkGYMA5NS9H'
        +'jwQ4R3fyvSnf++uG/w7r59T0Btyx0tE0DZo+GkQ9EMMqw3Ztzw+/8fOmQYcL'
        +'zdBFG+0q0rAGYOj+mPpEw0cv+4x5s0M0cmHG4YgnrvjiiHNBXBSMRy65GVxY'
        +'gZsVhk+uOeK++blF5ptPzgWGMYMc+HL5kFMKE0YoQs7py8kiY26ghy65Fdbd'
        +'kMTuvPfu++++D2FkJqcUb/zxyCePPHvucWJKKNBHL/301Et/N95fLkUzos8F'
        +'kIByLsJzgdnyHmH++einr3761v0Txfvwxy///PQPRP/9+McfW/781++x0rNa'
        +'zjoOMxVFwA40EyBfhpDAwAY68IEQfCDpbpCDClrwghjMIAZvYKRGHOKDIAyh'
        +'CEcowva4pw8oTKEKV8hCFuIHe4MKgBZcpA9NJGwpEKjHoaigQBj6kF3+E3BR'
        +'K5ayAQw0RRkuGtwPl4i3AFzDRetImCTKlsND2cIADeFgDjjIxS568Ytd3KLM'
        +'qELGMpLxY2ZMoxnHqMY2OuV/BftPKaiwjnzo44rLclE+Zre+PvrxfGx0oxsD'
        +'Kcg0ErKQa2RifgKwPdC0gw3w8AcHAlDFMbVDUQq5wRTYBjEjGUFsn9FCVQLA'
        +'B1AOhh86kBkxTDmYHmYPie+6YSDGBDV5WSEOasilLnfJy17u0gq+CUApPkHM'
        +'YhrzmMgsZimeIxAMaCKZ0IxmKUJQFQOUYZjRzKYxFeFKRaYlABNopIsmWckx'
        +'JYwhmuTkw4xEhAOCUpQfkwMrA6OPVH6sF/P+DEw39bOUdhjshpIYExHMhjar'
        +'BTOf/uhFtIiAUDZUJQGPmac+9ulNrATABPpoFjl1eKgGdDOd6swWO90pNngG'
        +'QJ4StWcA8JlPihZnKf5pVjXsgoBqjMmh8tJZww6azxgJxAckbVoZHoqNfN7D'
        +'pRWNSgBSkFFabZRWHkXnJkOKrZHm06QoZWU9ZcbSeSIVM0t5lz5ksBQdHAqn'
        +'OXuZGXg6T5/+A6j5HOo/ElDUeR41qZe5aFMP9dSOfnSqVK2UVeeJ1Xxu9Z4I'
        +'/WpeAxDTQ6ViKQZo0ZjkmtadsZWVboXrPOVKV6MqFq9HCcAF9jqmvprzr4G1'
        +'lCcba0qTlnKe+1D+aVdZ+dnELAV8Y2LGUgagDVoNNKdqvawpMxvUmnG2rqy8'
        +'K2j3shTJ8pWSHHXRJT86hClY97rYza52s2ukDcjCFuANr3jHS97wEoMEo5RB'
        +'L8rL3va2QgMyK8N620tf8Sq0dLB0kW69Z1NaJTCnfgiwgAdM4AIP+A9bCCY9'
        +'1sHgBjv4wRBusDw0Ea0UkCPCGM4wPZiJgF60I8MgfrA2artcojhRo9A9lK2y'
        +'SEENuvjFYkQjIg15yBlPpcY2fuPX4vifmXovbLSaKEGjYIUiG/nISE4ykt/3'
        +'sQtM4MlQjrKUpwxlskTLAFTOspYncAEzUdLJWw7zk2tZYr2ctFnUhID+OEFD'
        +'2TIvUbQuwgYE+Puu+7r5zmY2gIvqQQUTpMAuAxhBCrTA2sHUYwP7bISiF83o'
        +'Rjv60SbMcSJlLOkbU7rSOhZYABDQ2+XwsIzr+M8ko/PHUqePIJi2NI5zPJBU'
        +'ZxrPiynFf9ZRGaqoeTluZUgjTsGLXvv618AONrBNyIFeEOPYyE62speNbGaY'
        +'YJQ6UAazp01tW8D3Y2yQNrW3nWxlkNi2ewPNp8kYjuVcY3a6mQ5tmBwAEoTg'
        +'3fCOt7znDe8RkDkB9M63vkMwgqgGAAMj2LfA4T1qWH8zAc6FTD5SoYiGO1wR'
        +'qUAdoh3SiFhAI25yM+EnrzrK17ISlapMLNL+vBfRz1wjLA9vuCQSLhh+PDs6'
        +'W6CEZT+GUGJEa+PzxGkCyg3bbxu8J3pDqBIbUnGMZ1wg7eR4PA0rW5GPnAmF'
        +'FlsvzALz4NK8p9HSLCuP69mff9MAsxXbiF1adKN/CxomTDphR5lVUx52pU4v'
        +'nTDnuQ5oSUunKhMuKIkbV6J23euL2bkp5UH1h5Td7KBCO9KLK7LCppSrcZd7'
        +'f8WWjxG4sqD0WuvV25p1xhuM63b1OeB3As4nNk0b/4VIxS+O+E8p/h84Z6Vr'
        +'8xnbkLcUhktZZdPWQVYC4d2gm8ds5/s+V+SaUrmj1wwCZC0yW0Q1IrsWtvSn'
        +'32sTkqAa18i+9rf+z/3ua18bvQ8AEbDh/fKbPxockFkgyG/+9m8fG6JXzFIC'
        +'EfXcjq8hNJL5v7igd7HZXCCxZ0py8FA893Hxl3w5sRQmUHJjcg4pUHjQFwmZ'
        +'EAkUWIEWeIEYWIHM8zEGgAAe+IEgGIIiCIJnEQADMIIomIIIcCscqIIuGIIH'
        +'aFv/FkCHcg9MwIIEQmT9s4PsNgES8INAGIRCOIRAOAHn9A8GQIRKuIQSMAG3'
        +'EgAP4INMOIU/OGcI+E1LwQShthz8AA/jdoUVxRQh4A31Fxj3wE3xIi/MBYY+'
        +'xBQYwAfK4A3kQA7eoAyKUDZpyIbYwxQQwAa2IIfkEA7MIAnolYd6eIj+JqZG'
        +'GPEejtCIjviIkBiJkPhCCKABG3CJmJiJmriJmXhO3sOJoBiKG6ABWPQxECCK'
        +'qKiJMfhSNCYRRxBBsBiLDEQcrmZptcgUqyZpiMhEg6AKvqALwBiMwjiMxBiM'
        +'vvBCOtAO9LCMzNiMzviMzHgPzKQ39wCN1niN65ACMlMK1XiN3tiMyLeLBEEj'
        +'eUAH5niO6JiO6oiOCfYx2FAN8BiP8jiP9BiP2DCAAjEC0VCP/NiP2HAYSPgJ'
        +'19CPBDmP3iaOP9SLdaMxL6R2ssd2TAd5t4eQ4/h7mdd/TcN3m+V3oUeRMKSQ'
        +'C3kuDel57+J4WtV0E+mRGWKR1KJ5AYBQGrn+dRyZXKuokmkBkiFZLiOpdGf2'
        +'eIiVkh6JeS2JkTUTk6YEejRpk0iDkzmpKju5dkvnk3AHlBQplMbikjA5fBtZ'
        +'fH+nlB3Ti8bQlKpiDC/EBAglVwEwS/nkAzKTX7SllFYZLFiZT3bGUPmkcwwI'
        +'ShPllR4zCH75l4AZmII5mC90i7homHeBmDWJV6fhS475mLkETB+jCXFRmZZ5'
        +'mZepCT4QLRfwFZj5mZ+pCRNnAFoAmqZ5mXywmHy5mqyZEq8oi7DpQLSImLlo'
        +'Y7Vpm62Zm7q5m7zZm775m8AZnMI5nMRZnMZ5nMiZnMq5nMzZnM75nNAZndI5'
        +'ndRZndZ5ndiZndr+uZoIsp3e+Z1QIQiCAJ7kWZ5CIZ7mmRSEIAiEkJ7QiZ7u'
        +'aRTr2Z7x2ZzwWZ9DMZ/4yZz3uZ9AoZ/+mZz9GaA9AaAEapwDeqA6YaAKOpzr'
        +'2aAFyp4QSpwSOqE6wZ70aaFJgaE30qEe+qEg2iDsKZ4hWqImeqIoaiLj6SUj'
        +'Kp4u+qIwGqMyOqM06qLzuZ41mqM6uqM82qM++qNA+qCtOZ9AWqRGeqRIeqQK'
        +'kqRM2qQ6mqH5MaIpiqIvOqVWeqVYeqIVyppbWlEkqhYJ4iU4mqVkqqUfwqFl'
        +'mqZXmqBKyaZL5KJg6qaKIadPgaFRCqV8SacwBKdpgaNiiqdX8SF3mpv+eoo9'
        +'fIoWDFoc3dmnQpoZXZqnK5pUh5oViZoZi4qojYoZj+qVhYo3k4oVfqoil0qp'
        +'mXoZm9qmkVpRgtqnnYoXowqqpTqngIqqoDWicZqqijqrURGqjqqrKtmqSIOr'
        +'oHqql/GqV0Gse4GsHgms4Mmr+WGsy6msFMms3+msuRqd0oqQ1Oqd1mqpvoqc'
        +'2SqO27qdlYoZ0Kqc4QprVIEQ46qd5Vqs33qc6VpmkJUADXCvDZAAdmEZ7Zqd'
        +'3Wqu8YqgAUuvBhACbEAM5KAP/MAP+9AOzBAIKVBrAhGr+/mv8IqtAwtaCqgM'
        +'LAcZ+oANohQAHXCuBfGasQlB7WOyJzuLKbv+sg9EHCrrsi3rsg1EHE9AszX7'
        +'Gzg7izq7s8ShEBarGCQLrhmbVCaoDKTlIvsQDmUzsvinBgYWtQIWB8gSBYQg'
        +'tQb2B1SbIVYgCFhrYHngG6fhtV9LYGqQImNbtgRGB2K7BWSrtgHGtiv5tnAr'
        +'tzRCt2ortwvxrkJbtC1hPjubs1oEYy/GQf+gaCSUuCPUHoPQQo7bQi80EfPq'
        +'TZSEW++SD5tpAfjHNXpCB8hiBcHiuVwbLH5gBaPbK1sbl3PiB20bLGG7kq7b'
        +'ur3yunvbr7vqtywxL6FrHUDgBanlBTFwuBaHeNDAC5FAKrogluhyPRExuUy0'
        +'VEn7LvwwVN2ku43+Irr/ALq9IrqnQbqm272oi7YsmSesC7uzK7u68rqqKye0'
        +'C7S2CxVDKxPWqytxwLu+G1jAK7yttwzGSyq3oLxcUhHO+0MBsAGW2zTMtCic'
        +'myfYq726wr0O3Cile7r0K76ki76Nor7jSycaHLsMEbSJEb8xMb+NUr//0Lu/'
        +'G7yHZ3b96wj/K5YBTBEDjHuCp1XopcCh+7k5TMES/L0RHCipu8Gri8GB0sHn'
        +'a77p2znui7ukyhMkDMT2m8L623ot/MJNGcOSy8R7GACagFDtkIZPnCd5oMPb'
        +'i7Y/DCgTvL5vEsQXjMQSTMRoDMd60r4JwbchrMWuucB6YsIojL8qHAv++1vF'
        +'AMy8EDHDTdQAQXYP+VCGgcEP+JgQTRCzJ3sEKSvJsEnJv2HJl5zJOIvJGaLJ'
        +'sgizoByLsBHJowyLpQy4nfzB7/sUIgwTuQKii8DHXiAktgwkXpADh+sKy+Ak'
        +'vqwk/Hu8U6IlxIwlWCwRhix3QPYf+3ANiDYB/uQi5HCEFdvK6onHKAEc6qYa'
        +'uPMPPOAd4Owd4dEInXAK6XHO5tEJjAsf9tHO9yHA2Pw/FzAm8hCy3sM0LsIP'
        +'TNBDNtDP/vzPAA3QrcZqt5lIuigQc5DQCr3QDN3QBV1GD31Gl4ZIrCysAIux'
        +'eMbFLnIPlmcACdMA+CxEA5AQNwAEwHPSvCP+PAJhAGygBS790jAd0y6dAtGC'
        +'AC0t0zj90kaAAAKRADed0zJdBi+X0JNQ1EZ91Eh91HPwMQ1QBkCN02XgA1gE'
        +'hU791DEd1VMNAVVt1S9dBjpQikv8pxh9ZwGQl5BxDxLABPpA0yB9KOHwfAah'
        +'SW8QUlOgy/8QRCJzkP9WM+1wAR+zAUVZFXMACLRQ2IZ92Iht2KgACB9jAjVD'
        +'DhDwMTJQM+EQ2QFgViLjDQ9Q0WK9E0/QBKAd2qI92qQN2hNtm6522jMGz3hm'
        +'APKgtODzbG3NN6kX14DFSXUtEHhtMHqNATWzDn5dwIH9D4Od2MaN2Ivd2I9t'
        +'2ZMtMpX9MZhtMJr+zdmiGs8KAdETEcadax0Y0LHNQg+j1Apicw1YJAGR1DT7'
        +'QGLJ/DUYEF1jItsh7SJlgxAgpU65fdc109u/HdyA3XyCTdjHHeDJfVHLLdmU'
        +'bdnR/S7TXbsWfbEcAVkhoAMvTQUsADWGWLJ6nCcmfAFbWDPnMErMVzPMMNIQ'
        +'ABhNE47Na93rEgAc4N2gAd+0Mt8HUd+4bde7/S76LTLA/dfDXdwBftwD7tgi'
        +'A9kG7twIXjMLHtbVvRFLwQGp4A30sFf8cA/rUA0OdeG/keF0suEdLjIf/jEh'
        +'LjIj/g8lLjYoXsgqri4BEAIu/hkwfigybttUdd833iy69TEaUDPygAH+PC4y'
        +'9+XjP57YA54CHs7cBQ4ylL3ZtZvmSPHKDLEUD8AM+8DI/jDlIUs4Wj4nXC42'
        +'Xz53TTPmZX7i6s3oedPezfLmY2JE9D0EKI3SKv0PCBAIcjDrtF7rtj7rADlX'
        +'sn7rvE7rWpAAH5MAu97rvN57RJ3UyI7USw2Fw07stk4FWd3szk7rN/gxEiDt'
        +'0y4H1c7gnQ0mA8AHlP4Z4WBE1ZvpckIH1nEB0fzbIC42oG7iNXPmD7HeHePa'
        +'px4As01DtV0QMzADYPTvXDQDA42bqj1IBa+IApEGCr/wDN/wDh/R63rwCF9p'
        +'1K0fjq4sDSAm8b6Zl2cG6/jx6agG1vEArcD+DCZ/8iif8in/WB+jBdWg8jCf'
        +'8tEQCA9VCtEQ8zhv8rmGzKSeN512KKj+H+QA1wZhCUZ/9Eif9Ek/8KsN8Tp2'
        +'0P/wDMEw9VRf9VZf9UxP0U6Pi1t/4SC8Fxd/EJtmfCLDD6nZQ00QuDmb2myf'
        +'aqxN1l1MK2zd5bgG1gZBzsqT98YzCiZkTVwd0zQtEAiw1X+vBUTA03NF+H9/'
        +'w/+ADNvw+JAf+ZIf+cjA1IrP1V/9MQ9w+Vad+ZTE+U+d+Yve7Xxhenq5zwZH'
        +'75qW5//BD+cgh4iWAMTgDQUIGvCEECscN7xwCLqd36Pk2zrO38MdDM+AD8Z/'
        +'/Mif/McfD8+g3EP+buhGDt1IruhKbvHYHACpEO60Qg8FJy9PYGp99P0SP0ht'
        +'j2lv72ZLUftn7VFUMQAufg5WiPuAzMK8j995/fv73ecG41PEr/z+n/wAEe/Z'
        +'vwAm/B1EmFAhQnIQCMpYGFFhOIcBdEjE6M/bg38dPX7sSEiQIJAlTZ5EmVLl'
        +'SpYtQxJyCbLgvYw1FbYKEODkETN04vwEGlRoUDNN/jX4ZEvpUqZNm2rSGcBI'
        +'L6dVm/ZiozOBJKpWvdoqpTPmR0Ewx55Fm1btWpUBNmDMRwSDBrp1U+iLyE+R'
        +'2JONYi0DHFjw4MC8DnWcYHOhsqgYFCtcd4Hg28cIbekM9gzfZs6dPXP+FkjQ'
        +'YOWDDR+SPkiR4EXUG1eKJMlW9mzZhMyODWCgV01vxD596kUu474QfEEeibNI'
        +'+XLmzZvTMYqBHmqE7aKmon4wmoF/ENZl95fP+NiytM2fR482ZyuJ/OrBgx8f'
        +'3vSI8gaMB+mX8P7BhhFTZ4wgx1CLbDLqLvsns88W9Cy0gqgzLQCIUFPNIupc'
        +'U0mk29LjsMN/bFNPg4zoMQKCnHKagD2MiMnJJOScgxHGOIy64LvszomqFPCY'
        +'GaA74bK7Bz+XyvOwSCPNCwCCH8FDiAMhP/ILGv6m9O+fC6hjJioRUZMHAwNR'
        +'6wUzzRgk08EUqDunoglJi9AH6sLhKEMij6T+cy0QzwpAR4xSObHPBrTJyAAh'
        +'X4yxUOVmtNJGNHPcsUclwQtSrTnrpLTStlKgiUl/qGgxpUZGOSVUUUclVdRR'
        +'GukIAUX4YLVVV19l1QexElgVVltb1SIBghqo9VZbZcAMmW2GJbZYY4tFhiAI'
        +'evX1VSq4S5LZZlt9liAJApkWVia4kzM2S799bcOWcmono1Ig0OQeerQ4UZOM'
        +'yhg0OUMLRfSCcm9kNDsefYT0SZYmBTdgSwMoIx/w+JGkU08bOaQRhx+GOOKH'
        +'PeqzYosrpvhijTEmaGOPPQomZJFHJrnkjjxG+WSUN1Z55YtfG0lgmUu6M6YA'
        +'EKhpHX4Q4kfQACT+ySiaQdUQxA+jj0Y66aMFQXQCbOiBOmqpp576mqgUUZdq'
        +'raW+R5YeH6hma7GjDsfflQCeOe0Oc5JB0cr0gdcCteemu26aY7Yb3JpdkhA1'
        +'nz/JqB6FPToiCisORzxxxRWPwqgBLqgrcsknp+uCqB7YgHLN69pAAp0ez3zz'
        +'zTEwWyW080ZdPQl2qwyb4jqwg6U+Zqe9dttvH6Rllzne/eWOe++zIyiGJ754'
        +'44/XHXixlA/+d+ZhFjf1I/cetwzSvLnPAGZqGlx67006/XvxUcqJgyUxokfW'
        +'ADrwI3qTBlFlGF/mp79+++eHpY//+OG/f///31mAAuAYABawf/4okFv+/GFA'
        +'A/pDFjqBQhY2MUEKVtCCFDREFkSzQAYC0B8VgkgHPegaC4nwfxppAPTGNz33'
        +'tUUOpDFCTlKwD+6VbixGSZsNjRS+FfYwYwXpRTvukQ996CMf6opGDDslEpbA'
        +'bxhPhGIUpQjF/P0HNQIcEGkSSBnSICiCFwSjBTO4QdREaE2VqRBrrhenlMDG'
        +'hx6iHksCwIbK9EJQCfCGTbr3j8Itzo9+bJyyJjBIQhbSkIY0EUEScIFDNvKQ'
        +'D4gKBBw5SUJ6TlItfOMb+zSBFOiACCnAwH0GhzeVOHGKp4xiFf+RmCs2hjpb'
        +'PBAEJRhGWo7xQWVU05sqosbKYKiNpMzkeeL+uJIAuEkx2IBkAFQUuD0Sal4w'
        +'gs4/MJAp6tAjKstEzTW4IwF5gGcfOjwJD4OZSYuF01spMSUqUalKVpIGi6+U'
        +'jAJR48VZ0hKMthwNm3JJoV1eiI0oceM4hYlJ8j1AMeFoQE5YVxOruUhez3RO'
        +'vdxGGhwRRE9YctT5SBOptIhToB8F3zlRkk51TpGdAHIlgeLJxcrQ055hxCeE'
        +'9kmaNPpThSCdzTDbEoB61IQePltoTfgQL4jKiEYTrUxF89QofgEJnOAjKE6l'
        +'+g9gjlQV98Oq/U5aRK521atcDZOA/PFVsnaVHPEUUVnLug+c/OOLL72gLUkw'
        +'VrV+dR/aqAgL6Fr+167elSMW4qtX94GNFHZrqmzRaVuwuRB6eO5nJ8RIIkvi'
        +'zKIuR6LgUepFUbOvRzn1kocFLUiqepJB3M60ps2d85SXPOCxtnfCO15sY+va'
        +'3dHWZbZdGcxEGlqXJDYlARhBRth1MyMwwQjH1QI1FWI1olaWOdGUDnisY1Hw'
        +'bKc7SH2MeD7L29COlrvf1Zt3wQvQqJ4kN9XACLA0dg6JAGsnW1BDfOU7X/rS'
        +'dwtGSUAZArFf/vbXv/5lF0FSoIj/Fti/iiCCTgygBQM3mL9Z2e54cSpeCVcY'
        +'jh618IfKa14f4CUiyqBCiEVMBSaUQbkIUYagTtKEJyDBxS+GcYxj/IT+I6j2'
        +'ebi9LfPK2dENZ1h6FPZxkGuDYQv7ti3KwAgDI3IP9wqZUkR2st2AHGUq93bK'
        +'GTbybw3AXk3pxWyFi0KYxTxmMpe5xnNAc5rVvGY2p/kfyIBznOU8ZzrH2a1Z'
        +'wHOe9bxnPmcBChGusviuHGhCmySghM7ybydwL/Dw6ctqyEOkJT1pSlNaDUYB'
        +'BCo0vWlOd9rTqJhDgrYRj3SU2tSnRvWpt5GsLBjC1a+GdaxlbYg/87jQgt7t'
        +'rXVt6EFXONG/xcA1ssMPOezxOA917iKiCQhaNNvZz4Z2tEGdoHSQydr4SAer'
        +'DQFXWtYaLVDeNbh6He5Aa+jWv/5tAmyBGib+G/vYybYsplERbXrTe9rBqPa1'
        +'GZTtf7Sa22H09lnATe5KjZvgUT50uXu80xS0Y2c12UcqfMYSyjoXUZmud8ad'
        +'fe986/sz/Pb3vy8YcPIs/OB1MvjJg5zwKqN7pwHQwjXk4WGE7OMe65DFBNzt'
        +'UHgrZ9nz1njGOe7xBYF82yK3IMljMnCV7zDXTUd0yr/rcmLm5AJEkIMmSqEJ'
        +'RWjBBBOPyREgXWmyV/rS/8j0p9Xu6VAHY9TxgHvc5T53ua+637PG+6yVPiST'
        +'Q91DUvf7eM1daKqPS2NpAXOZFa94o7TZ8Y9PUJ0lL/k799nyfN57S5ge+PQA'
        +'nvPcHTyi+/75um3+nvS08fzpD8tyKhceXEeAfexlP3va1xjHKbv9x3LPMkCr'
        +'HuVP932RUw9a11vqCFswQ/KVv3zmM/++/zCADo47fepX3/ruDYAGjGt97lOf'
        +'CSRQsAy6P/7py6r3wXc6+hFuet4Wv1IVryx06UMdeVwHPNXYJnYVo4+nloT9'
        +'6hc44APA7xqJ0QM9AzQ+ZLO4o8KsfMGopqIOjvo2BBzApRPACmw/CiQ+DawT'
        +'+Cuqy8IX6tKXjOqX88PA8xi+E1RBSnE/SvFAiALBRRHBB+ysCOw/0eLAFTQn'
        +'HeRB1GnBDlTA+IuOnsoOayII7MgO/PsHCWA01OA/E+xBSbnAKKTCOvn+QTo5'
        +'AivYgi3kwi70Qi+0AqMwgBBIgTI0wzNEQzR0EoKYABZIwzdMQ9L5hwHgADi0'
        +'QzMcgRskixysQqqawj4ERA65QiysvUKkvR/SMUS8MRtrLSgMRM37w0eUxNrg'
        +'w0kUuEqkwhS0xE08iUE0ksRbvFAMsxpLEgkwxVNExVRMxUQKgASYAFWERVVM'
        +'KIJ4gFi0xVOUrAnkRAu0xML5wl8Exi0Iw39ogi3ggmNExmRUxmXkgi2osSZw'
        +'g2iUxmmkxmqMxjGosSNwg0Lgxm70xm8Ex0LYA9sbH08sErFTmnRMx7OTgGg4'
        +'h3eEx3iUR3nMEoLgg3aYx3yUx3Uoha9RhnX+0MeAfMeGsrVdhMReNAPbUMiF'
        +'ZMiGtI08iIJ/iAJCqISKtMiLxMiMrAQ7QAKJBIVm+IWQFMmRJMmSZIUf4CNc'
        +'EIeVZMmWdMmXFAdrQElK2bHewkQPecFniiZ7AY91cMDNIkHPKkiDPJtIVEEk'
        +'UIOeWw6IlMhF8ISnhMqolMqp9AQ/6MgoYIVm0Mqt5Mqu9MpmqAWUPIJfcAd1'
        +'MMuzRMu0VMtumMkiuS2WMEecDMIPZMAQXKoRhEB200OP+L9H1ETVQ0qlVA6m'
        +'jAKnpMrDnEqrlMis/MrG9Mqw5COyVMvJpEy2dMvcuAAt+EeuuodrkIQRSCgb'
        +'issOycl5iUHUyCz+pqpBvXREoiQLozzBwBRMwjRMxLTNqrxKxnTM3QRLsZRM'
        +'ygTOs7TMtSkmZaAhjAgHPgjNNrpJ0pxLGKxLGbxLGtSoypDAS3TNorRE2VRK'
        +'wkyE27xNxcRKaiDP8jTP80RPaoDMsZwHd3DP94TP+JTP4USPnBiBaqC5mjiH'
        +'rPCX0eQQ5KCEnoOuE6sMI1Qm8NCmJeym7Pim1sxOP7TEJ9iCOKivCq1QCo3I'
        +'KFADO+DQDvXQDwVRO1CDjmyCQgCFE0XRFFXRFQWFQsjGS8CFGJXRGaXRGsUF'
        +'ViBHJAkAKjCYVnoS/0wPUBTFxTOK3ECAI0XSJFVSJVUxI13SJ13SJjX+ACil'
        +'UiRVsaF80JDaxCN4gi710i8F0zClMaNoAi4V0zMNU9gjRkNk09kj0zaF0yPA'
        +'IR1lg4ejDm1AACEB0iztiL4MxL/kU3ILACLQFH9IMfzYU/Q4AiSI09ljVFLU'
        +'sRNRxOeJVEl10OwE1NPLgRuIgU711E8F1VDdVEZMxErFGFNtHtoArvwEj4QZ'
        +'j0Q1j+Mbilmd1aI4ikAohVzV1V3lVV4NhKjwgVTo1WHl1VQIsATgA2JVVl1N'
        +'mEt1zUz9vBtIAi+g1mq11mvFVi+YAh6AvlZYB3IA13AV13Ed13No1gD4hG8l'
        +'13Vd17YKAEVQV3aVV3CtR1UNgCbUFA141eb+/M/n1EkaWdBX+knSiAZH4TIb'
        +'dFaihFYL0z2WyAEnQIOIldiJpdiKRQMv4FYDQC8meSCCIAZNaagAkAVN8Ukk'
        +'4YNCTQhsGBxYpY3SNJTTpKiBrQzOqs7HuM6SC1Qt5bycaIALMAJF0ARJkAS5'
        +'aABRWomHtdiktViMhb6NBY+ODYCPZZKQHVkmKdnZaEV8lQhFqBwkSy/jYNnZ'
        +'cFl6iU7UlNnHoNkSxNKc7VPYrDK2SYWa9YdzSAUduA+VQFql1duIZVqN1RSo'
        +'lVoEjYqq7cm9NAmCOc6MwAafQVc7XYiy+YiwlY2xjRGYTaqzVYy0FUpdZNvX'
        +'hLqcCAFm6NHhiAb+8POXvN1bpe1bp80OwAXZwSVZwy2JAAgqidAHWSGdPHFc'
        +'hdiHXJRctqBcaIqO+UON6QoAJKQO6/IO8NCutWXbhQ2tnPgEVq0JL3uSh32D'
        +'1FXdjMUGTQmrANgeJtGGqKhd1DBC2UiScLAJoQkAHNHdJAuwlxAfWaXV+v0J'
        +'W+WVVNDf/eXf/u3fXyUIH2gF/yXg/m2FY+WDAlbg/YWKhDVI6D2s3FisymAM'
        +'IbmBC86BDNbgDeZgDr7gGyBVSkXVFhnhnbOZDSBQhcgHFggATRCP920PPvGI'
        +'312LMkXTG6YxSDXVEH6tEXbgXYRgqQqAAShf0tAm2UW/W8oIFpGAewj+EhiW'
        +'CKGZYX7NWT8FxCAGqZzQrEa7W5CAhC8G4zAW4zEG40ldRB/evYZliwA4k4zQ'
        +'hwQ40Ccuhd1dLr6gYSCm4hXE4o+aI5Q9CE7Jj04olUEm5FMYhUgQMC0YsUVm'
        +'ZEYuDtFQ5EaW5EVmYYIIgUie5Ew2P/RtY4zIihEwGDmm44QgSA3rXBTMYxXc'
        +'43FqRSJE2Xvo4o5ohFOYkloujExo2r+NisBNwmuKXawlgVE+COwxgHXzB1HO'
        +'iACR31NGvVQ+wVUOpsaViHuoh2q25nqghxQ+CAD2iFm2ZVvmBVz2W47d5dcl'
        +'CMLNjqtdYw3QZn/IigTQhmu4hgoug2rQZn7+CIspZuZm3mcIDbcAmAD92wcS'
        +'gICCNmgIeIAsWoie4Qtv/mYqEWfWpQ7XnVrYtVokppgHyCOJ2ACPAZy8iN8P'
        +'cdt+hqp+hmZNogK4YFyLyQgIk2Vafmj+COdcJmePNWeR/WWsRWeF+IQQ4ICf'
        +'5gB9TRINkOiam8U+deYHteI+PGkfGoAJJmVmkGqpfqAA4ICM8IaGhumYJoyZ'
        +'HuenLeeKPuecRl8qoN6D2Aevqr8WzgdhHt89JGm2WOoqbOoVasWNfoxfDQBj'
        +'nmY4fulkAOzAFuzBJuxk8GrjDKy1kuG95ofELqt6PN7GduyvglysNQD9Wwhk'
        +'bi+MjmscNOmRHq/+AHiAdl6IfLiPBgjYiMiHNfwHhzmE14bt2Jbt2X5tVCnh'
        +'qChhHm5ErNWC7EqAYhZm9u1s85jrTARt8EoS0ii2AJADYT4IfWiyQMwJvK6J'
        +'cMAGbd4Hyxlu4k7qCqzr8Unux3jjVixqhYBuvhiE9Fbv9Wbv9l5v3a4t+H7L'
        +'2z6PJCHtx+DP7ebnff5u8QlvxfiEnMgnjDjvjhgETjCFBFfwBWfwBjeFUMid'
        +'AWACRaDwCrfwC8dwRdCBqCACScjwD8dwJogKHfBwEDdxRYCX+gyBQr0MztZv'
        +'pP7sf36A0XVjJxkAvoYL1u4DUyipHh+GW3AE6BM2JkGQAPBa8FBZgsD+ceqA'
        +'Bxf/iJzg0WHbDid/8eKOwv7+nrtWDGIQlAdIXIy4B7/+hx338ZKChSD/6tYN'
        +'a8Ed64tOj5zQAcy23QCn8irv7gHE8u95apvQBxH/GcUgB74g8zJfJzQv78qg'
        +'aDbHaTfnkAC4AE0464iohg2vczuP8X/u7ZoI9CGOdIVo1o4YdEI3KUPXZZsW'
        +'60UvXA9BkSVfCHIggvuQmxdH5UvfNbdI7YiAF4J5DEjyCDLPql+vnzOHvmjg'
        +'IBPyIHf9WGM3oGrwZWUvoIryEAsAgNygAmWAh33A9s5UBM8BAAdAgjFrAqO4'
        +'AR4g93I393KfgdaOhHVn93Zfd4f5B/eW903+tPIezPMsZ/WEsKacIF6MqGqP'
        +'GARH4ISBJ/iCN/iDH/jcKYjtI7/uY4I1BC6Gb3juM4Go4ACJn/jq2/AiiYI8'
        +'6AAHmHaL6XYLeIIAXQ5KiIMaGwIx0Ns3mAIQbgRokPmZp3mZjwVUcQRfKClj'
        +'UKVJrHcevHfvcXQaV4houAAMUATnRoh8EHOijAJKoARCMAMkoIEOsHoaKIIo'
        +'oINKkJEaAwKW19uXb20pqeWb/wdO0IUe73lZN+6D+3OJ2Aeo6fSEcOmPaNQ2'
        +'lcgh1fuIlMgyvXvaw6HG+fva4/sOKUylTPl/+Pq9FfuYt2WzR3u11x+2p+vj'
        +'lrCcCF9N4fLxkFD+C/V8+jKDDFUDOiD90jf900d9O+ACEt2DS3D914f92Jf9'
        +'S3BRPioEVsD93Nf93ed9VgCFHE2Pw++5xF/8sId5sp8SyE97M598yr9yy7/8'
        +'AFBfJqEI/ODOnrODDP1O8ERM8WQFauDN3VzPX2hP+TR/86dPDhF+eCN+sFfa'
        +'xkd+/lB+yXf+tj+5JBnyO9VXk7h+eKNN7gcITwIHDvSD5F8UVs0WMmzo8GGz'
        +'Wj/+HfnlTh3GjBo3cuw28R/IkCJHkiw5MsqilCpXsmwZ58g/IGLQ0KxpE82U'
        +'G/8aQVvm8ydQaLEa/ePkaxjSpEqHwepj8inUqFKnUq1q9SrWrFq3cu3+6vWr'
        +'IEFfx5ItGyBBKn9q17JtuzZVggAmkahpaffuojxREC4i6PcvYIMIFUIs/FAi'
        +'RYscFzP2WJZklDySJ1OubJkLTCBTNnPuvDmJzka8RpMuPfoUUUewVrNuvdqU'
        +'08eyZ9Oubfs2btxhc/OmHWDACG9uh/sjl2KA3Ll18TJPqZcv4OiBDyY0bJ0h'
        +'4ooXGXPP6Lh2kyjix5Mvbz5Kk383eLBv77596EyR5tOvP5/oIEf69/PXP2hQ'
        +'bwEKOCCBBRoY0m4HKkhVAA0SsQ4//LglITxaNJiccs019xxK0nlYEHWEXWdY'
        +'dop11913C6q4IostuvhigQnC6OKFGgRCjDf+5ITjDTF8aHChVEeYYRmRReYR'
        +'x15R2JEIk006+SSUidhx0BOX1HIllllquWUtoMB0BCvWiDkmmWWaac0vH/l2'
        +'IZttuskmSG++GaecbdJZJ5Az6rknn32WJKOfC+LZYFVHIHEoookquuihMD3B'
        +'KKSRpvfEET9YeimmmWr6wxHpNbEpqKE+YVsAbJRxKqqpqqrqCHIdsEIPsco6'
        +'aw8eyBVAGFjouiuvYYgglwJBSDEsscVKoQKGgSq7LLMBAtostNFKO5IB+tBz'
        +'LbbZapvtPZLIVcEsx4g7LrnHwHGrPeaouy677zwiVwbSlDMvvfWWI0qy0+q7'
        +'L79/itXvsjcIPDD+wQUbTPA/gyoM5MILJ9zwoLYZcE87FVt8McYX06PIt6sA'
        +'8zHIIQPTxq3vjHMyyimbcwe80oDzMswxg4NJvgDbfPOyz+IM4w1DePYz0J0l'
        +'wcM/A7DRSipJK70000y3wsStWiDdNNVUs3ErE7JUvfXSHEtMccZhY7xxxyKb'
        +'TXLCJqe89soty/w2zTvLPbeeOtO9Yg5J3LQ33zZ5QbQB1xA3eFu93MoM4Yn7'
        +'g82ttihOuDw1lzWx2JVXTPY/FXhsdshoB6D22ii3/U+8b8sc992pqx7jv6vj'
        +'7UTfsd/09z8GVPP44LLcSgzuxF1zqyy9D7eO5GRRbrnYmGvOeeclh67+Msuk'
        +'u2w6zKj3ZmikjB4B0w05xPA9+OGLH4PAIDVyCPrpq79++vj18T788csPP4D/'
        +'ZC+pejeMv3/4OkXCPgDZ5775ETB+9Uud3VxXoBzATnYOpJ3thOcW3SWMdxJk'
        +'y+8SFrwLroV4ErPWtkKorW59K1zlKte5EpYudrHQXS2zFwzxFSAkbOEPNrwh'
        +'DnP4Bz/EIT08mIIXgijEIRIxiEmYwT8ykYxiMLGJTnwiEw/xjz7o4hZWvCIW'
        +'s3gLXTjiH00wgx90KEYb+oEOUdgBD8RQxDUOcQhLaIQwoChHJ7oiNbDQIh6t'
        +'qAtYdFF1CVTggBjowAcC7nYcVAsFA2DBQ2b+MAAbPKQHaxMAPrChkpa8JCYv'
        +'KQcTuIpWnqzVre4QhlGSspRh+ACwpHCGVbKylWdA1gzNoCGW0MGHXhjkTZyA'
        +'xEz0BCi+/GUypNiHoyylmEoxRhebsJxZOscKaMTlTdzYiGT8sppAGUpRdGHM'
        +'bQ7jFn1EYOsAeaAbJEEM5jwnOtOpTjFMAXDEyMc94inPedKTnvkoBfD0Uc99'
        +'8lMZtyqFPvkpUHlqo3hjgVidHuYwiClUYbFkpkpq+Q8e3BKaNNFlEntpTWAK'
        +'k5jcXAoyvbhMZubBmTywaE2kSc2NVhObnNDmR5fizdX9UZy9Wc8QgKDTnfK0'
        +'pz3NKdECgAESELX+qEY9KlJJMIFbTcAESX0qUjFwKwk4FapWJcEGDGrTAyFB'
        +'lhBdhEQpilI0YJSXLOXoFD0aU6SEVJlfzYtJx4oGlZ71ly6F6VqRMlM/hnOr'
        +'fhUnQuXU0IgxlKG96epbw1pRi5ZVo3VdRjDTmtektHWksyzpM8dK18f+5K6T'
        +'1es371bTv5JWbqXSAmpTq9rVqrYMIZBLCNaRj9nStrb6SKQ/aqvbfOzjE3Lh'
        +'gGx3S1t92EKrskHsVxU71sZy1ieRHeZnh1HZt2L2pJp940qb69nP7hWcpR1Q'
        +'IyKRifGSt7zmPe94iRIAAySgve59L3zjmwAD3Iq98r1vfOmbMPvit7/+CUCA'
        +'cbtigHzIo8AGPjCCD0zCf4zgHokjxq0UlwrYOphw/gzQEbYQlg1zuMNhIUQP'
        +'JzqFdZLYnEdM4jLmqGJh6sIXLn4xjGPs4mSqgRAevvGHq4uGEpNYmiqeYzLq'
        +'+A9H3ELGRn4xH7+r5NkcwhXQeDKUoyzlKUOjGJmonTYOqRYIJywaWvaHN27V'
        +'iy/XI8BcOR7yMoa5Bj84womb8D9CUOHBXRjD91vU9tTjPf7tT2BIPF8AAz3A'
        +'AhYQQE24M6PSIzA+8+8GS/hfoAX9j0EQmtAHXDKmvdKIUzS3mry4cgS1nMhF'
        +'crCRj+RgJGmD5jRrzGtsJhyXAyBhCieuzpn+vjWuc/2VTXf6l5+unSEPOeov'
        +'m/rLqZ7Nqll9OVfPmTixnnWcmz0cW/PmUYhOFEwCmydtE4rbycHetRs1WMN6'
        +'e9wN0zW6q8LrXgPl16EW9u6IDTxjm3kryVb2mqXtlme/mdYWrvdYaGiHgRO8'
        +'4AYfuBrSgwA2SKLhDn84xCWhiRTIxQCfiDjGHe61ACgi4xn/hAFAYoU4HLzk'
        +'BFfDXgLABE14HOMYSBgJWN5yiPs2ABDgw8xpvtR08xwqhziFY3stDFALTsvF'
        +'TZgy5J0wx2m5HQDPygDW4Y2pU73qVq86OeTw23UMNB+J5MdA9eHbfwC360c/'
        +'rBo+9BdC7EUC65D+oCbk8gAJ8sPNwksASLhQCbUTJBFWALYEmZAwRVywQSTI'
        +'hwR18PSeY7oRo4gF5CMv+clTPhaniETRypCKUnC+857//OdTYYRbUWHzoD/9'
        +'6ctwKyOYHvWu53wgFn+VAISAA7a/Pe5zj/sQQKDiITAB8IMvfBNc4FYpGP7w'
        +'UyAB3yN/+MWfYdr5PhC2/wMC5JCgt/4xd+Hp41b7kCDe/6F36QvE77Xzcu/4'
        +'YYSEBaLwAXh172RgUGuH+1B30vb9EZp//ZvbYf1faLn5CaBFGgGql7fByf/x'
        +'3wHaCePdBl2Qn0BQn/Vhn9xJUPclzPfdXd7tHfmZnwGgH+6oH/u5H/z+4Y78'
        +'mUSGqYEKriALtuAKmkHKsZYMrhYV3AoGzCAOasGPVB8V5KAMql7C6IAPslYZ'
        +'DEDCcMAQshbF1Y4PJGFrxUUDRqE4PSAESuD1CU/2bV/vXGAAZGDvhN/4deDf'
        +'faDwiGAAtJ8ENUgJPs4JlsQRWNYs+UF6BMA9JJgdHpjTJUwZ0MMd3iE9XM0/'
        +'6EA79OEd3sOtKAMh2mE+IAD78WEiHhg9tIJcQEA1OOIjFtg9ZJWf/AcndqIn'
        +'fqInPswAjCIplqIpniJy3MpvoCIrnmK3rWIrxuIoyp5VwKIsomK3CYAu7iIv'
        +'7uKt3GK3DQABDCMxFiMBEAraQaAnWCEFap/+BXof+G0gBHogCD6OGaKh8Kih'
        +'viVOG5LEG75VXswhPSibxXhQAGiBPJBjO9ADEOrAOqhjO5RZBcHjPTDiJKUj'
        +'OdIDnD1ANNCjJvLJIHCCawwkQbaGKnSRAShCNDADQzakQz4kRAJiAMjBQkKk'
        +'RVpk9gVAGVTkRXYkQ8KZJNkC12yNLIzePywAGMCBSq4kS+pBD9wKKcSkTM5k'
        +'TAqBXDAAJoiCTu4kT4qCFNDiVtBFJQwlURalUQ6lH+zFA1SiCIVQPWjdPzQA'
        +'CDWltpjjOlKltugDI4pfIhylVxIl9RmALdQDVmZLO+hAwrABWZYlthhiAGxA'
        +'OLAltuQDJ6EgHGr+SB6IIzyaIzqqIzvKhTvCozwqEj3aIx/gI77tYz+qYyYC'
        +'ZYD0gSlEVzHNVOB82dEFQNJpGeMs3ZfBg2NOxYDJ5QhlH7icULl4zgqx0Lq4'
        +'kPTAkL3I0PVEwRbMJm3Wpm3OphWkxwBcgAb0pm/+JnBqwAY0wK1sQHAe52/e'
        +'CnIu5z/K5m0+Z23OoQQY53IGpz0mAHVW529m1XphgHYC5wbolxve5YbopTry'
        +'JWKy2l8G4juq42ASQ2EmzGH6pWL642fyBmRK5lIk2btx0LBpWbFp2bHJxr2p'
        +'p9csD/N8jOeAzvOMTulQz8tYjxTm2jdSl3mSI3r6ZTu2Jzm+Z3zeI33+yt1i'
        +'kmNj9kl+6mdS8Gew+We8Aei8Ceh9RkWBppnybE6CLujziE70PCiESiiMjEqc'
        +'zE16BKm0PEGNEQKSJqmSLimS5mXCnEM4RKmUTimVRmmYJQwV6EiVbmmUkoOF'
        +'/AMLeAOXjqk52sKYcmk7hFypaOmZTik5jN0DEEObVuk67CCfnCiKdhNCrugF'
        +'XWZmMtKLQlKMQsWMIk+NJqiCOk+OjoODTk+PDmqhPMEYTCqlVqqlUuocQsAF'
        +'bCqndqqnbioUBsCnjmqn7lwATACppmpySOqltmqlptwDpOqoToCaJoCskmqD'
        +'GIAE3Oqniqc3Oid0BmvKjUAIFKuxHiuyGuv+rTRAsjbrsY7AA8hFAjgrtYZA'
        +'qyQMBlRrs5LArUCAtibrCOzcAGjAtyIrCfiqnvRBKOQRu2bRQdZOK6zDOcwr'
        +'vdarvdrrOmTkJ7TDvfarvyaSIvCrvw4svTIDpJpEoVrOoSIqji5qo0JohB7s'
        +'VPxAIVCDxV4sxmasxdbCqEiAPEgQnBZewlxQ+LlBM2gsyl7sL4xB7RRd71BB'
        +'wkiC+5mAF+KO4k1oA+ZHf+wsz/YHgARAA0iA0A4t0Rat0UpAqCbA0S7t0RJn'
        +'wiTABDCt1Apt70kM2A0UP+lD3GUOMDiD134t2DqDHqDLO5St2Z6tPbzLP4AA'
        +'N6CD274t3KIDbPL+xhEUwog4BCuMygRiYQVyHzRq4D+4wS/cLXawLBmm3/qd'
        +'IQluI+F0I84+LuRWxVn4F37plwAcAOZmruZi7jEmDAP0FwPoVwAcgAKUrume'
        +'rgJ07vXYLeEuRN5W3xX2ThY+IwZGY+AObuvWguFWo+Jc4+JKkOOKhMC8B/EW'
        +'73okTC8mr/IKgCqmYsOkIvIur/QybwLWCXJE7/QuryoG1vVGrvfaTN22ruvq'
        +'bezizuz6be0CruCKr+6eXxkmLjb2jjYCb/H0TNDc7xQ4QVDpAUv2r/+qpOfo'
        +'ADMoAwEXsAEfsDIwAxF8Sxv8rwOr5NgmjCYgMAUbcDWoqQc8sAO7pAD+/EMC'
        +'lEIFh3A1PN/3lrC+hK/4vu7eym7fbuHffiFIrG/u7u77jmAavh/jDk7whsQN'
        +'NBBKeYFOBIAzmCYRiwsw3Er84o7XeAAwFDERO8OthAPJJowSODER60EHu90F'
        +'1aUJ48wCvqJDVS+cGBZvUGzKnjHH/oPHgmwLy+/I2q7JnjHKtm9lCg/MBoDM'
        +'3jDNJl79ToFcAXHCHAOiMs+t8MEFxd4/MPEgm80x3IpwRGMAVPEih4y5ZHH5'
        +'4g63djHODEA1hLAnM8OXakA0XJ3VZaTUkfLUhQMfyAUGjDIqT93WXs8TuAEt'
        +'17It3zItj4FuYoDu9fLthUC0Nkjt+XIva+L+WxJzL78WSMwyLjdzLY/BqJzq'
        +'MCMz7uEd0E4zNdvea62XBmTz7qGr8PrxWAFyAAjyJIdMIR+yXCjyOX9MIyfM'
        +'I2tgJJvzOVeyGl/y42SyJttMwlZOvrXZGxMOnMlZrUnsVFDK9iS0Qi90QocE'
        +'t+2f/4nxnIAEQ1f0Qjs0/km0m2B0YD3FDYjzDwcxPbdzOksQIrNzO79zAMQz'
        +'DM9zOzcxHFjyBenzPvdLPycPswG0rPVbtBV0Tf9VD/9xEA+xFZfLEduw8Cxx'
        +'Exc1uUAxPE/xPDM1uWCxGr+dBNH0T+vLTYfNP8Oa3Q3OQOewWlBbbjCzMzez'
        +'LieMpvJqp4YqBrD+NaeaKlxzqlQt81mfdTTH6lxfQK3u9QXUtQGg6lxjQMiZ'
        +'BDnh7/3urx4sNmM3tmMz9q0QwTVUA2VXtmVfdjVcg0lWwGN3tmMzwj9htmhb'
        +'tjao6Qp4NmpzcFS2wmi3NjbUdVbvy1arWU57dUCDtb/RmUFHxQ9cQjf8NnAH'
        +'t3D/Ni6MygMwQzusg3IvN3M3tzwAYgLcQ3NPd3OHw62cA3VnN9dtpRtYw3B/'
        +'N3A3g+G2gjxoN3WjpUaWt3k3Nz00yAZow3o3dz1wMUmsR/He93skjDHuN393'
        +'bq4aAIAHuIAPOIATigD0N4IPY30ROIMP+K0ceILzN/WuV4NXODjHdrT+zPbY'
        +'1Pbg8JtA5zZxkPVt9PaJbIQ7UAP5NqMW4g4XSgjg7oE4lLhGWAMNIy5Syy8O'
        +'0y+G77iuGUA9xDd1y4PXhAA9RIiRH3mEGM7IIjmS+wM+xVmRM/mRc1lvkLiM'
        +'Y4Q7NEOK860zom8X2i6MXzlG0Lj72rji3vAaKs4Oh8QAEqD6EIVGT3QAHiBE'
        +'+x+d0zmPS0sA+IAO9Lmf/zmgA/rzJYAPGIGhHzqiG4EyBwAVJHqiM4EmErqj'
        +'J/q1VvkliLk6ZPmWs3CXu3D6wvA/hLmYk/nhhiD8/q7wrPlOjIIrtLqrvzqs'
        +'u/rlJYwomZKt2/qtjIAkKAKv97qv/3rHZTL+Bdw6sZNS9JwjsCe7r2uCmn5A'
        +'sRe7C8gFApSBsle7JlRtnme7gVj5lWs67Ko47X75i8f4qNe4qd847sxvqhdP'
        +'I8RC0NVVMajXO6gmvbPLOCDxBXmNCzBqvdf7O0QxVN8BO/Q7vb8DKciFFksQ'
        +'fWs7w1c5KLgDxEe8xE+8O8wDilc13LWxNX417oRfIYgDxYc8xM+DNbgB4AmP'
        +'4HGc+x0eH5tEI7gCuwmDerHDouboN5S08CCyC3xDzT8POzhywJtDz7PNwd/z'
        +'TO92w5PKF8c505NxbhyBG+CC1E891Ve91F/CqCCAHHwC13e913/9J5QCC1Rc'
        +'KoC92Xd9RmrC2Z/+fSoU9hiwgtXH/dSzAssyeimsPdhrggYkjAncPd5/PT7Z'
        +'nCL8PeDvXEm8fMzP/NCvzc3Lpzr/w84vfsr8/FND8h0IveQzatFLAD4rDlYn'
        +'PZ8YwD7UA+mXvumfvunnw9aWphOnUADYw9nG/jukLbxwg2vSi9wiPVRYNO83'
        +'9Jw/dAD2fu/HuZ3c+UO7PMwLneJn/jg0/iQ9fuQzP+WvdNAzvzlsfucnzueD'
        +'vp5oeKuVDcMqao4+LMT6KPcDDOIrf8LQPPM7vyGbtFxEf+ZPP0t3PK1jvuRf'
        +'P8JnP+Fs//m/CEAYuNeOYEGDBw3SUxTgX4VVwCBGlAisDcMA78Zl1Lj+0dwd'
        +'hhmkgRM5kiQ4TAz/pVS5kmVLly9hxpQ5k2ZNmzdx5tS5E2ajWNCABhU6NGix'
        +'Rv8C2GO3lGlTp0wtKvI3lWpVq1QlMXTxlKtTexbJXRVrNQHSO++6dn1HiqEE'
        +'eWPh+jOBkmddu3fx5tW7V6VAhH8RKmTocGLhikgxblTc8WPIkiVP8pU8mXJl'
        +'y5MbZda8mXPnTEgDhBY9mjRp0KVRoz6dmrXF1q1Xv1YtG/Zl27dx57bpF3Dv'
        +'doIbPiws8fBFxYs9/gP5GDJd3c+hX1YdnXp169exZ9d+m7fvv8ArzBoe8Rgc'
        +'i4mPZ2SXfDnzkaKcb5e/PfSABxc05McAwUD+6Pn/AQxQwAEJtGmAapRJUMEF'
        +'GVwwGi0YikAPRiis0EJGlLBoml047NDDXbAYTJRcSCzRxFzOiK/AFSUL7QI2'
        +'bAnnHn748Uefc5RRZC4VnxvEEU6ADFLIIYV0BCkVkExSySWVtGgCI6CMUsop'
        +'o7yAIQWYzHLJGixKgcovpWRiAKQqqEHLMzMQ4B8DZADTTSYS4JHFOelkKYAG'
        +'8MxTzz357O8fAQ4IVNBBAyXAIgYQTVRRRP0UQIFHIY300QPkrNNSm0IzoBR6'
        +'aoTrnmpC8I+6QVQZxpdTUU1V1VNvGQQpcLiJVdZZaZXVIjn8oVHXXXml0Z9A'
        +'GFKh1mFpLccibHr+TXZXf8oK4AxYiR3WJDUlCEfZa/0ZodJLue3W22/BDa2M'
        +'fDqNa6p9UhlgW8tIHcbdd+GN991WkSrHvXu5sYgPc8UC9h9h73XPWKS84feq'
        +'Zp8N+LFyRKE2LIOrImFdcCmu2OKLqQvAAE0gtuqaOKNrV96R4aU3AHsVLilf'
        +'pPbteCp/AU6ZpIEDKNhlZpFKWGaRGHb4Zn8kxlho6wKAwOijkU5aaQQYMgAC'
        +'CaCOWmoJGnBy6qknANnpq6eueuhwDejlZ6rg2WBiyUQmmWSTUd4ZVn1/hpkb'
        +'t3m2yGaXEaYbnJ7/keBhl4P+WvDcBsAmmsMRT1zxxK8pgyENsDlH8sn+KV/n'
        +'E4vooVzzc9pZ6B/IN6+8lLMHBzA0W8au6hwJSNcrbbXlZVvvlQNo2WW59ab5'
        +'7o7zpptvv38OvPThKevOu4OAG+Eec4mxiN9UGAph+biUaZ147QL4JHWrmAE5'
        +'t3ZXDT9V2emm3faOcffdIm1+7p1uTHy+Wfjr6cfL+OMLSn56uJpH6vno9zeW'
        +'6tVvRQGQ3vasYgTr3cVHoXDgAyEYwQdywkgBqMEFMZhBDWbQIhjQAhVAGEIR'
        +'jpAKWsAAQxiwQRVu0CIyIOELRaiFMQUgAyu0YQ1AoCYD6ACGPdSC9wgYxJ3c'
        +'D3+/8ZzymOc8c0HvHwek3gKF+JwAiC0u9Aj+BzYiF8CrrINpuunDF8EYRjGK'
        +'MSW0mU5szIiSNJamjGsUTRvd6J84vjGKdbwJEfGnvyT6b4kANNcA7TifAJAg'
        +'H3DhxycmMJoUXCMujgvkIyEZSZng8Xh6jEv/AvC/JmrxKoCU5HWyFxc+hOYB'
        +'OtBWACSwDk+J6pOtdKUQDaAPesySlrW0ZS3vkZV/kEAff1RiXGTBkBEUMi7M'
        +'gOIr86IxVY6lHax7wD32wQ85hEYZcQkVMrGZTcHN0TRpRCNrvpkabeomAA+I'
        +'SzXiNAGqkCM0xIjL5cYZT3nOk551CoAO4kKOqjXgLf6YZgDYBxdsHLOeBTXo'
        +'QRHKk9qZiw2h2YD+MjShLjbsIy71IGhCMZpRjSI0AJIwlzQzFZpSUDQu97jo'
        +'RlGaUpV+sqP8ugcERqMDTlrFpNmh40pVQghC4JSnPSUarp4YgAvIQQOh0QA9'
        +'4tKOk9pFNE4z2gNGs1JBCMKn8hTETqsaoACkIJ9x0sBb9OG4AASiXFepxlJ1'
        +'IpoLBCIa3pgcOa4hCwWyUqM6zeo4CUHVu/7nTnFZSCinoo84bYCkYtElOQOA'
        +'AW1Ecyz7yMfl6JrQvO41m3alrHw0tjurNDQAqaAKP/pDgsJepajkbIAsOnaP'
        +'udZVr5d1pWVdiz2PjgV6AZjAOvSRD2AFQA5lrQo9IluZ0KSgHT8rBRD+ETrZ'
        +'2LYStssFZQiIeZV6yEA0cTIqPOACIdyEhg0zNdg1WIdR5To3ks0lb3UCgLqx'
        +'0EMSKbjAfUYgieKOJRx+uk0AqODbm5HDvgcd73kDaV4AQycAGoiuWO5BD3nQ'
        +'w7tUIQJaaxKAYSJwKsaEcBT/O2AMY1XDGWMDhafSC3Xd1wCaTR0/HHnQqXbY'
        +'jgJm8XYD0AoKhwO5lglAGfSbOhpfOIgrfrEQXfxj25xue94o7X0T8DexrKMU'
        +'OnDyJ+YLlxQXNMhCHlyVrSzcsebYXLaAaW4CQIR3JkBdonlAQJkZ3Cyv2TpY'
        +'ZnOLthplfoW1v0MOQDTgog/qGoAJZhsul6f+cuQ3D5o6GSa0lm88I0PuwxZM'
        +'4zFNQjNaq+xDEcygyl8hYOKqwPPQnc7NVT1939BQQRnh+E2C5UGOavABqo+O'
        +'8AVc5o3+AA8u4XB1qHHNElDnWjqZukAIUsABDVj31hE2gstqOwJJT1rNvHb2'
        +'swlkGlACNS75mGUpmGYARpqr2dD29rddyVt+ERuV4TBYtx95hCesm93tdve7'
        +'130EOMpGJd6c92vuXRtw7/tbAdACv4iAAQy0WgO2WHZV9oFuO0ZhC2Zw+MMh'
        +'HnGJOzwKTViTCWSQcY1vPOMhmGEpOR5yHSQSKRvQQcg5zoKyIOXkKN94Cop9'
        +'nSNEwQo1t/nNcZ7+8yjI+wY8AMLPgR70n/PgBv/oudCRDoSi/yMSncjE06Ee'
        +'9acfpRFNl/rVP/MPHzmC6133OtddpfWvjx3s/N7uCFy6jnWQY7cDsDRc1qHw'
        +'OkbBD4uw+93xnne9L4ISVkjJBJjhDcEPnvDeCIcsmqUDchSe8eFo6D8G8Ilw'
        +'ML7w1whBGddB+crH3DpIoIMfQB960Y+e9HGIgtGT4AXVr571qp9CDlDfetmL'
        +'YemjEMbtcZ97YRSDF59pxCiKoXvdF2MUkPhHH3RxC+Uvn/m38EXYOdF86d8C'
        +'FkYyu51vlkjeHnwqnnRlFPKwd/GL//T/mIAysJh+9WNRG6lAAFJk4I3+9c9f'
        +'G44cgCa0Mf/1R4MDZbyi/tUvGjivOpCg7sbvABchD04vB5wADRzwASHQAV/P'
        +'6KbgDSLwAmsvGZZhAzmwA5eh9/6hEU4BGjywBE/B+PoAdtzFGKDPF1RQF6zv'
        +'+mysZlzmwQKACXppLJhgAL8F/BDwB8vv/AAw/drv/QIg/oaQ/ewP/5LQcPoP'
        +'Kf4vCQVQaJDgD35w/OhgAZPgAi9wAm9gCrgwAjOwBD0QBEWQBMmQA0/w+FTQ'
        +'XVpQBW8hBmVQuALBU66hHTol7kKDY+CizlrJB69w/IIQ/ZKwCOFP/gpxCfNP'
        +'Cp8wAKJwCKcQY6owEPcuC/8hB7YwDB/QC8H+UBMdcAzTcAPNcARDcQPXMAXb'
        +'8A1hJw7nUDougPu0IQEuoAwCgQ1g6k6UzCpaQe7mLvwoce8GsQkN8QgRcQjr'
        +'jyHubxEhsREfEQAj8WIm8RfxzhIx0RMlEPa+0BrRABRDcRTRMBRPsQ2HQRXV'
        +'hhVbUcs8SyzkoahIAwKwAS7yQdDCBd9ygu6kUe/8zvwCT/MGD/Hgb/H40fAe'
        +'L/ImLyAtr4zOISAF76yo0ADvMQEXsAE98Q040RrfYOlOoRSXARqEwfdIsRRP'
        +'0RhUkAVTghNccBXl8BxbJASQSiz2QRm0wMm0oBq4bypGp2LUig+YgRzULhxa'
        +'wQj6gxdXIgrUoCj+jfIokTIpi9L0UiIBmKAMoDIqpRIqfcAAkGIC2GAqtbIM'
        +'rukIs3Iro1ILHqCMvhIsoVK7JFEp1VIpzeD0bmAInCAu5XIu4zIJsBEu6ZIu'
        +'p2DpOsEV/PIvAdMvTyESQrATYiEwEbMTjI9UVKExHfMxGzPsHMEUILMyTSEl'
        +'VZIvAkATAK1j1uGE5jEBtEDOriIaTGDEbELdjmA1WbM1XfM1WTPfamONwkmc'
        +'avOMLKYJYHM3d9PijO4GgDM4hVM4f3M4jRM4U6IzlDMzknM5OSMlBiE6pXM6'
        +'qRM6qfM6pTMztcydEEgfdIAHSYwKcpF/JAY8tfM8e0pj3i510NJbyqn+mlwm'
        +'H0bpbIAzB47zPo3TPmUTnG5T2vozqv7zpi6Gm6TNm+ztQGljP6fD3tCzRRCg'
        +'FMbmHnak3yZgPA2GH3pB7nhgCJKgQz30Q0E0RDuUB1LiADxgBVA0RVUURT2A'
        +'AJBiAVY0RlG0AiwiA2Q0Rg8gJQSgB250Rc1TimzhGoR0SIm0SIsUGz7BKgNg'
        +'BVahSZ30SZsUDCxCE+pBHqz0SrG0pv7hA6ahS730S7uUFIyQCO4BS81UHtrh'
        +'wZBCGti0Td20TVGCBMjhTLGUHqJhLBt0MkIjEHIQYsJB+/rNAEjzZmxB4XjA'
        +'C7RxIoEgJSJAOMYDGI6BEXI0ADzgGB4VIo7+IUP+RA8s9VJnIQN01BkuFSJm'
        +'4UfJqRqKCCHkwRaUtAc69VH1wCJQi9tSwgW+IT02YheahQr4hQosom3cAx3U'
        +'5B9koE/HghwgIE8pIzTOr8HOZR04ax6rgcL44fFi4lAT1RMX9R8adVQjdVIr'
        +'1Vs1VQDg4FXHYxYqIFRHFRhKVWgCAFVT1SBWtVXNdThiFSlmNS5QwlZxVSN0'
        +'FSl41Vx8tV4URlhToljNBVmVVctGQBOuoSWpQh/IoRfKwLooJgAgFMTuQR5b'
        +'AluzNQy3tVsv9VuRIlxHdlzLdVTRVV1V1lTBDF7jlSDmFSlcdVTvNQDyFS72'
        +'9Vb7dRz+Fb969Vf+C3ZYETafknVhtUwWR4AFjEAGTGADbtFlbWwDDgyBMrRS'
        +'PPZjLzBkHXU8SJZS67UwMpUhyDVsJ2Jl/0RUW9ZdYTZmZzYAavZSbzZnx2Jn'
        +'e9ZndzVoCTZgDJZYjVUsFBZpe42NBlS9xmLtyCFxySEcOAUuQPMlslZrIZBr'
        +'vVVSS9ZsJWJs/yRlPTVd03Zd2xVj3jVmC+Jt4xZWZZVf7LZnfzZg42JgT2Zo'
        +'D/ZvryJwBZejNgBirwIeUEMCdNcqzkpOIldy0eANKHdkLRdsxZVsOVVlQfVz'
        +'11Z0e0EbqLd6rfd6r9cbSkFJV2AWoPR7i+MTrO2WaEkfUEIEwDR9s0H+TJHC'
        +'CMaXfGdJTQPgTelXGlbmH0xgHeB3lj4FT2/3oG4sqTIFAQjYAEigHuKii1yC'
        +'B5xgChz4gSE4giXYgUn0HxYADOAggzV4g+GgDZTARQOgAjh4hDPYA8i2B0iY'
        +'g8EgAnRUD1J4g6XUXQmUjgzUjBSUcG04QEWFQf+3oMJGgDdmSKvBG2rSH9qT'
        +'JeozB5R4iZm4iZ1YP3V4h3OYNqN4WHv4ilEqABLgHAQ4Aaa1YwoVi8V4jFvk'
        +'AWi3KpTKi13G1l4CP934OG8Yh2t4inkYJ2dYjgQgj/V4j/fYNRI0iqPYIvh4'
        +'kPNYjXKYjMepaMxFqQxAEaKBGbChcatIeBv+eIIteYIrGAJKoRc4uZM9uReI'
        +'QRGUlASU4ZNNmRh2ECnkgBhM+ZNlAQPKiBla+ZN30V214R5wOZd1eZd3OR+I'
        +'oVWdIZiFeZiDmREsgjv1tVbZ4R2YuZmd+R1+tgz4RbsCAB2s+Zqx+ZrH5B/w'
        +'yVzgQQIQOZ4UWYBJYwJaoTOBC3K9wAKJ1wGNNyU2wFmnIhwaACn+jV9u0gDw'
        +'zFz2QQZSYgAMJuHYlnRlllVpFnMjYm5Vt1Z5tl9bV29jl2+J9oyrwnbDGZvG'
        +'2VNkQAeMwAe0710FWJ3beXLh+XfFQhvqGWj5BZ4MYD3zzJ8hz2DyQWrvq23j'
        +'1XQRGiIUmlb/gV/+WTdvBVZoJXp2E/ZoLxqjG0Ce92Gpl9pXA8AH4mKgRHqk'
        +'HXBbc5dfUBpgDYalXXos9OyfZZqmh8ymUxWnbTZ1edqnHRqoX1eo76VvixYu'
        +'LPqowy0BzK1jlKrA4qKWFxhRqRoNrNqkryKrVdpcuHrOYBqg+WWmB5qgzVpu'
        +'0TqZe7qhcfWhg3pv33qii5qus2kA0hFi5MGh4kJN+/qvAbuksTqlXfedmqar'
        +'xeKrY3qxxVo6HnZ/bfseegGYj2G3ebu3j+FmqUiyXWAc0mKZf/ae44Ka0aEc'
        +'mLu5nbsc4Loz/WEdjJqzw40J4kKzOEuax4IfULMlgGCdqfqd/4EDqhb+cFMa'
        +'ueOCibTNYHQArM/NXXWACei7vu37vvEb5pAiAno0RTPAIkygLLdymlKCAYTg'
        +'wBE8wQ/cBWYIK80SKkkuAIJgwim8widcCob1AbTgwcsAKBHrjkE8xEV8xOmN'
        +'p2xrmcQiBCaAD0pBE2AuNDQtxLDW55KuxpOO6CBvAi5gx3m8xy9gPyzCADDA'
        +'x4kcA0CmnIacyH3cKpEiyZWcx0lOhmc4jm+Kjv/Yyku8jm0MAfiky738y8E8'
        +'zMV8zMm8zM28zKHKp7KHy6ykNGQMLmoMie1i6ZBiJujibO78JmbbumEisVLg'
        +'zwE90AV90Am90A390BE90RV90Rm90WXAD1P+qpwE2x+0QQsuYAJ0nAnueiyy'
        +'Ys+XS2MIONRFfdRJHQH8JAAIgFBU/QAMBSkMIAFgPdZlHdbVqNRH3b4GYNZ1'
        +'nczKaNVVXY12fdYV+L4woNGN/diRPdmVfdkB/dE9fXgC4MPiQh8ouiqoe1sa'
        +'4RC0fdu5vdu9fduPIpCpnIYZgALM/dzR/dyZPADSvd3P/dn19BNmed47mRgC'
        +'QUk94EL0HUP0pRj1j43/QQQ+ZOB34Q6UFAmTkLqQIhdeoeEd/uFfIRdQggOq'
        +'oRBtoZ63q9iZfeM5vuM9/tCdXc0Ba3u8c10yIRZ4IeVVfuVZvuVTPusY4BFI'
        +'YeZpvuZn3uCRQgT+bH7nZ14IkPER0jd9d0EEyigbgh5MdwHeW+Qa4KHpnf7p'
        +'oR7q6SG3D9q3rf5mDVdnGbpnzeG4IRodZJdYi9gfzqG6pUPjPz7t1X7tHR3S'
        +'VUo9EWiUZiIThEEjNRIaso4CpuFuu75ZtoLvk2MASMEc7jYbiB4x7nYcskHp'
        +'NZOsi+ixURdfF3qy79ay2xqzg1WzjRbM0J7tPf/zPz/kq0pj4PNmqlXu6N7u'
        +'SxHvU0LvE/9n/57rA3/wC//wjaPwGX8vRtexDRpucxoYdlq4KTs9LB8uYBdY'
        +'mQOuq30q5trGOh/0oT/6N170Rx9j5dkq1oEFeDH1VT8NWf8fXL/y/Z7+HQAf'
        +'GWm/Zw2/jNCjXxe/sUkX8scj+LWe8n9aqy87ojObqDc/4w/dBELg/wEihMCB'
        +'BAsaHDgihcKFDBs6fAgxosSJFCs6lGEgwL+NHDt6/AgypMiRJEuaPInyZIAA'
        +'KWzx8wczpkyY9RRB0Hgyk7BlPHv6/Al0GbRMGylMG4c0qVKkuxL8C+CC3dKp'
        +'5u5oHEDK3NSl2URsDPBuK1ecKcuaPfsxwDV6bNu6ffu2Xi8DT3scu4s37109'
        +'GgP0mgnYH04X48wZPoyYXdOnWgLP1NIXXbnJlCuXQydgo4x9jmOug4D2bAAM'
        +'EVkkWIk6terVrBNwsGjRBAcTsGunIBGCtm3+ihjJhv4NPLhwswEMhGiVzzE5'
        +'Njd9l9QZNHrQoUWPik26GKrU64Wt/sOqlXvXr2G5j8vmfLh6tAH4fHoPP758'
        +'+aW0DHiaoY3+/fz19+irBTG9DEhggcrgRMEjCi7IoIJh0BUACQIWSGEvI/SF'
        +'SYYabpihKDhh0EqFFEri1HojjRaRDAFosg45Lr4IY4wyvrhOABrsFpEJZZAj'
        +'BwkNmTCCbjgqxAcxOjxEgo9D9mZik04+iVJqGmihiS2fKKLDaSuZBZ10XvJE'
        +'3T9GmWdOdlGR6R145mXzAXnmnZcelHJ6xFqddvZ1p2pP5YnaV3xuuSeffv45'
        +'qKBzcoQiRCz41Vn+o4HZOCSSgfjzSUILmUCELWUIuZsMzPhDxUVXRsrkoaae'
        +'ut6daEUyyimuvgprrLK6GslGCLggRK667prrB/f9mVqghAprKKrGHotssnMm'
        +'+tCifzkKLUyQ1kaFDymwUC1tLDBBhSaUkkCEFloYkYIi/hDjAwtGiEsEQ0YQ'
        +'wcS4CmGrBRUypMCEJDIYwcS6RphAhTzhUMGCDuIeaVGpyi7MMJSNHAJxxBJP'
        +'THHEjRRabMMab8xxxw0z65Cz0UY7bcL6XMMCG/6UEqQk+vhDD6VGrFPPPvdI'
        +'co4//HjDRz307HMOuSnooA09L9+jhQnE+POyMiTIso8P6+wT8z1MKKP+8z5U'
        +'hHPPPZ8oyVtGHo9Ndtlmn4122mrTSZqijI7saMkVscDMPkRgo8+/IdRzDxvR'
        +'UKoDGzow4U8vkvDDDBVUCC6HP4HQpgM2/igiSeGNR2OEN/5o0UvUU5ciC6Va'
        +'CCxHY8oY8W/CYq/NOsMPVww77BcTmyfttQMLKO5xts5778mC3JDIcDcqd0WN'
        +'SwJ0CClw4E84Gpj7SQrK6POyLFrw00oIROvD2eNDY5MPCz7oE00rk2+Qij+S'
        +'dC71PUTIwU8pOpBzTQo+5HwPFZxKpLDv/supE2h8yUvQ6MRGNnAPaIWjAYyJ'
        +'Vik0YoBqQIsfMtjIAKK1j939b4McVA/wGLL+KKhRb4QkLKEJSZjBG9WGCOR4'
        +'mSR8FAJ+nCMElfvEpErBB39Yjx+yCMHSFPEJx0EOG/sYnD+UUQp/aIIDf+MD'
        +'+9bhPvjJjxzYuJcMPmGz11Skfx3sInC6NMDohGkDMXOUNhgYACpE6xMQ/JSj'
        +'9FHB70QrHxr04tlQY4AE6DEjgLJjSj64EBbwUXd2MsAGbGOCZ8mANiO4hj/O'
        +'kZxPNI4ZmrMFE/aRD1ssrRfkmNwQ/dGOdfhDDkzIhz6YoY91jABrUtMHEXJY'
        +'Chlogx/aYAM5bLEPbShvi6vzoy/LAsYwAmWMZWzUGZ+iRmix8R8GcGOj4GjB'
        +'OdbxlxtDDQnkIIv+aFxjm8r4BBUu0EdqigSQCwnBBs6JznSqc53rnI1tSKCI'
        +'fWBjl0PrRTU0YT0dpAIbrUgFG0zwiWukggq2wEYqBqqQyN2jFdf4hAxGIAdl'
        +'aKMX1pJDK2SgiVgaoRWb8hszmEAMbdgCYbycpjhPGkxh+oSY0DpmGtfYRmhB'
        +'U47QouNJyYYaJnjjHi8BDNWiwYFw3hRRbYuUUSlCAvP9kyEmWCQJdCODJNGG'
        +'BPeiTVSfmlBt6CMFi1QI5ExAGxP4SKwpEGtYqzq0/U2Ei0Nta0pVCiai/IOM'
        +'LUVjMh21zGbKNI4XrKlJ23qqlVxAG3CzBR8B+5WiHnWxD5FBKojBAsb+BrIU'
        +'vYisZGvDVsSK861wZamjvGFXmDLTmZ2ZaV8dZVPNLmwlKhueP+6xAaGelJwp'
        +'KAEKWoDb3Op2t7ztLQpK8E5LXfY2YBtuSVXrVl4UQxjMba5znwvdYsj1AtdY'
        +'h3Wvi13r9sIpAdCBPLIL3nXw4SqpCGV4r+uNEXyFHufFrjf+itwmFSd9roWJ'
        +'PqggW2rSNgU4iAIX/gvgAAt4wAJ+Ag6Mi+AEX6SX8aVmJDLRiUxIeMIUrrCF'
        +'OzG7AUBgAhzusIc5/IC+GODDJObwaZ7SgBJ/WAJ0ecoFVOxhCcC3wcNZCX3r'
        +'C5N9GGHGG9wvDbYgCD8IechELrKRiYyEAyv+eMkIziyNnwzlKIsmAK3FcUz0'
        +'Ac62+ngLi+iyl78M5jCDOcnGJetD1FobsEIEzZhlsJTfDOc4pwUDVgaMPPLr'
        +'xy2Lec987jKZL2sCOVjoIkvFkQkC8bWLbMqoTpZz6wbhiEhLetKUrrSkB/GV'
        +'Ayhg05zu9KYPkJl/EMDTpN40Afqi6VJ7mgBfUTWpeezokqxEc9Bqy8s6IwdY'
        +'907Pfe71l/8MGxYQwYrpWggRdAC1Q8LLByZggT6Ica9lg3DY71IICXxghCMd'
        +'WhMjGDYR2iUDZdBjkdgWWpt1HeuOOQIWt2i3u98N73jfQheO2AgDRJGLfOt7'
        +'3/nGxAGeAgJ+Czz+30HQiADOMHB+vyIDX0m4wtGdbpC81FHXkAMHNKABIkjQ'
        +'Mfc48WwV65Af+3rkiwC2RYhwDWKEIBrMuFcK+LCOdoQjHxwoRTiU4Y0yYC0f'
        +'1ZDEzcPBB91ofC3kCMQG5BAOeuTcBKlQhgawUY12tAOI++BHNQLhjWhknaTH'
        +'jbjvHHGLYYh97GQvu9mHYYx6/6MC0gCH298Od3CUIxf/DkANyhH3vJfjDBoh'
        +'gCjwnne4cwMEGxEAOgIfd25A3OsdCQCtO9OKQa6kMZ3RxOLVxmuS99nkFsHa'
        +'X1qhrXt4w2X5UJomdLAOZfhgH8woQy9Of45qWMoI7aiHHNpxjjKwVxH+56AH'
        +'3cJxgZ+xSBtMwIY8pBa0iHI9bJdnfLIcoYuzS1/6amc74uH+irrf/fpv57uo'
        +'/859cAy+8IcPvzSa73WWJLAz4VhJAlqBe0mEjv3ovyPIG0KDKMRBDfzvv///'
        +'D4D+x3kUATAJ5HtW5TgcMD0b4AOlIA/8oAwYoA/Z4wOfAA/8EA27ZAT0IAkp'
        +'wAb3kAr8YAQkEAgUxAzARw8Z2ArhwALKcA4YIDn6QHxsBhGN5nxlA33Tp4Nk'
        +'V31tF37Z9xTbF37e53eAd33j9w+GF37gcH43yB6N0ygX0gDFBC31EAL1Vzb7'
        +'hQNIUARd6IVfCIZhGIYtgEhacA/7UA86gID+irBy4SNziuANzCCBF9UicHgN'
        +'GkgPpWACfHAPpcAPSaMIJgh89WALx8GCLqg9pXAOL2NuXeeEapODO7iDPbiE'
        +'QGh3Rnh9RAh+3IeESmh+WBhrAWA+nVEPK2EucKM1oDg2+1VbJeCKrwiLsSiL'
        +'sUiDpRENE1g42sJercAP+qADIMgG+lANGqAP5OCArcAG+XANSjIz+fAJ9RAO'
        +'TAAP9NAK7PV7F3APvXAc5NCC+RAI2UQFraBj5/aIaxOJkjh9lPiD2oeJiKeJ'
        +'7Zh3nVh+3NeE5ZgSegV5K/E34VANogQtgaCKHsOKTEYRRmBQLKANyoAwbOAN'
        +'4UAM2DACpXAN0RD+DZCVCuHwehMZDQqpEEYAD8xARWwQAlpwDeRQDfpDWRpw'
        +'TyOgCJC1I8QQCBNZDQ5FjvaINueIjmaXdhuRAdJgGT+JDnQXhJLxk5WBDppI'
        +'lEU5GeBAeN+RlEpZDopnkyiRAJKDa8VBBBeQAHmkAfLgKJIQkB3DiihAlmVp'
        +'lmeJlmipEMAVbDpwLzrAdXApA2pYMG55JAUjA3U5lwuxgXIAl141ly4nA4vk'
        +'llzlcm7ZVH9pGzY4lQ0zCI8JmZEpmZMpmRhzO7pjO3ZimarSmCVRlY3CBnWS'
        +'AD3lGGD5cRJRAjCgmqvJmq3pmq75AmxJkAUpD3IwmzXoZp2pm7t5LAn+4Eid'
        +'EZoBQDf64A0asBKj6BiKEJYcQ1soAAMzMATRKZ3TSZ3VSZ03sAIocJsTIRu1'
        +'yGSMyZvhKZ7DYQBLA5zF8ZvnshJl0Bn8EJqnCRHOOQRvgAb1aZ/3iZ/5aZ9v'
        +'EAMrsJ3/iSPgOZ6mMgicYKAHiqAJqqAGGgqY9g8IoAOoI6ETKqEp8CsQ0C8U'
        +'qqHG+RQjoKEa6gMMhEwfSqE+sJxvtiKNMl4BYAsxUQ0IEACUFxiudKIa05ww'
        +'MAT2SQY7yqM96qM/uqP9eQJDegIAaqRrlZsDiixg5wtN6qRPCqVR6gvDoHYa'
        +'0A78gKVZqqUvgQ3cpUZbCqaUAkFYA6Zbeg/+LBBNZWqmNRplAcAEtxYYvbAS'
        +'3gITchoAk+IY8DABbMowN5qjaOAFdSCog0qohWqognoGWKCoWOACRQobWLVk'
        +'kMpUxXVmlIqkfKqkJYGTOVl2akdXZhRayhRTb8RX0pSpiHIBXukY+rASHNAO'
        +'+jBuK+GPgXENmLpa97cQ8okGZFAHkGAJvwqswSqsw/qrnWCsmYAHjloRJrAP'
        +'yiBcC1GYuxGtmOIPzEBPKRACf5E0iuIN8uCdDCGgp/okm8qpY+epVOgYLnVX'
        +'jZJXpLWqpepX4voV7joTuRYAE6AD4DRxjoFfN+Wnu1oHlgANA0uwBWuwB2uw'
        +'rpCsFYEbIeAPGUj+AiMQAgkRAtcgC4cUsSGgJBJrKUAyAk/lA/ekPDrysBo7'
        +'Ah9bsZvDAR3LsSYgNfTwVALhneEqryZCruVKpQeEroGhrqKFj88Er6hlqzQW'
        +'ABvQKPkQnCthAPHUGeSAZ17kp15QBQErQHAVHQqrrCnyCTOJgRugCNrUCixg'
        +'PiDIAppQDdVQCgohC9egDAohB2erCCYgC/ywDrLAAiTAntFAAqVQDdGgCSEg'
        +'QbYQDbaQULaQcnO5DvSgI9VwDYWGm0Nbsx1xs+V6rnWFTD5Lr4BhWqZaswEw'
        +'f46xD+vAtkVDmoFxhUO1Xy9gAzMwA3WQCVVrtUCBtRRhLuvwMszwi9r+4Eif'
        +'EA78sA/eAD/XEA6OUwqnJA8pUAb7cA3eoA+B8Df6cA46gLfVGgj3wAy2ywYS'
        +'hEkrwwLXcA/E8LspkLgpoA/hcA2tYKngmqSRKyeTy6mVC6qXK6qjtVfRFK+d'
        +'awDrV2cwYQtPC7W4upYLcQJY8LqxGxSzKxEsUA33wC8l25HtwAwkIINahLz5'
        +'kAouEUspQAzOWDnRQATfmxAkm4EKQQSTI0FyQAT0cA8y8LBIpw+25Hv+4A3t'
        +'cqnsayzrJm85nMNqNwGU5A0/DMRBHA6ywF06cA5BjMQ/HA7vOQCfQA5JjMR3'
        +'+BXrAMVRDLlES4z76w/asL55BsANMcAFbMD+P4HAKaIN5OADDhsNI4ANvXhE'
        +'JiCDGyAD6+DGqcBCr+UDf+Mz62ALRpAPxBDC7MkMRCAP1GPCm4N6cOQP+UAP'
        +'7ZBzvSe3yaGH/NPFNtwkg9AHmazJm8zJnazJDoqZmVknoswam6mZ7OumcFpf'
        +'64ABV6wsA5kCYYyws0zLA1vGihIN+cAH3sIMjaMMgaAPysCsQZM+svAJ/JAK'
        +'WsAEf3HB+uCX2UYF96AN9jK9zJA+7nHIvRAI+RAOLIy7PqAFqKe4bMAG9eAP'
        +'17pgrmzJ6/xkKzE+OOYNe4pYsDzAnTAr94zPrtIJCzsR8LMP/3wNOmBKCRQN'
        +'KaA58pBD+pBArWD+C9STD0YQzTaTD3LAAu0AM0QwAuxZDY1zD8khCY50pZvD'
        +'AkvT0eGQAvKQDynAD+aMvpSszuwM08i1EhIAD65lp5oFyyigA1/QBT3t0z8N'
        +'1EEd1EKQtRFhBFhSmDIgCVRQmDpQOkMjCdk2mGzABwgjA3JwepHFAoqgBdB6'
        +'L1SgLzrAAnPpA5LABPNy1GXwlkdiBJrABJaVIpUc03PNm6xVD6UbGPsQDlf4'
        +'0q/8xQ2BAkQq2INN2IUt2LCxP4mtG5yiZpfC2GimVortEN/KVXJN15fdmO6n'
        +'CMbHGTKRD+fwUX2iWrB8pKW9nTSL2anthEqrAT5QBnKgCGVgLzLmv/CGadq3'
        +'fduordq77XynTLR/jdvBvWS6zdvFbdz2J9zJ/Z/EfdzN7dwfA9zKLd2LxdzP'
        +'bd3XbSqjkZcswN3d7d3fDd7hLd7jTd7lbd7njd7pjd46YNnY7d7vvSx5pEfz'
        +'Td/1bd/3jd/5rd/7zd/97d//DeBaAt8DTuCoQkgHjuAJruALvuDrERAAOw==')
    return img

def next():
     import Tkinter as tk
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAIcAAAAAACBeHSRjISlpJS9wKjV4LzuANUKIO0WIP0mLREqM'
            +'RUmRQU+ZR1CRSlydVVahTV6hWVypU2KjWmKxWGi4XW2+YXy+dnHDZXTHaIDB'
            +'eoLCfYTDfofFgYnGgovHhY7Jh5DKiZPLi5XMjpjOkJrPk53QlJ/SlqHTmKPU'
            +'mqXVnKfWnqnXoKvYoq7apQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAEAAC4ALAAAAAAQABAAAAheAF0IHEiwoMGD'
            +'CBMqXJiQAcOBCw4QxIDhQgUKEyI8YLBAgoMCAzG0YKEChQkSIkB44KChwQCB'
            +'F1akOFFiRIgPHTZksKBAgMCLGTdGNIAAQgKfDAcgZbj0odOnUA8GBAA7')
     return img

def prev():
     import Tkinter as tk
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAIcAAAAAACBeHSRjISlpJS9wKjV4LzuANUKIO0mRQU+ZR1ah'
            +'TVypU2SqW2KxWGi4XXi9cnu+cXy+dnHDZXTHaH7AeIDBeoPBeoLCfYTDfobI'
            +'e4fJfIrMf4fFgYnGgovHhYvNgI7Jh5DKiZPLi5XMjpjOkJrPk53QlJ/SlqHT'
            +'mKPUmqXVnKfWnqvYogAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAMAAC0ALAAAAAAQABAAAAhdAFsIHEiwoMGD'
            +'CBMqXChwAsOGEh5O+KDBQYMFChIgOGCgAIGGG1isSHGixIgQHjhcoDBAoIQM'
            +'KlCYICECRAcMFSI8EDDQAQQLDDRy9DhAQACCGB8KTKC0qdOnDwMCADs=')
     return img  
     
