#!/usr/bin/python
"""
Code Copyright (C) 2012-2013 Liam Stanley
Note: DO NOT EDIT THIS FILE.
Run ./code, then edit ~/.code/default.py
Then run ./code again
"""

import sys, os, imp, optparse
from textwrap import dedent as trim

__version__ = '0.1'
dotdir = os.path.expanduser('~/.code')
configpath = os.path.expanduser(dotdir + '/default.py')

def check_python_version():
    if sys.version_info < (2, 4):
        error = 'Error: Requires Python 2.4 or later, from www.python.org'
        print >> sys.stderr, error
        sys.exit(1)

def create_default_config(fn):
    f = open(fn, 'w')
    output = """\
        # Code Copyright (C) 2012-2013 Liam Stanley
        # Uncomment things you wish to add to the file
        # lines with "#" in front of them are comments

        # irc bot nickname
        nick = 'code'

        # irc server host
        host = 'irc.example.net'

        # port to use to connect
        port = 6667

        # password is the server password. if you have a nickserv password you want to use,
        # try to set password = 'username:pass', as most networks support nickserv via serverpass
        #password = 'example'

        # channels to auto-join
        channels = ['#example', '#test']

        # channels to greet users on channel join
        # e.g "Hello Code, welcome to #Lounge!"
        # uncomment to enable (remember this wont work with ai.py disabled.)
        #greetchans = ['#Example', '#Hugs']
        # exclude users from receiving a welcome message below.
        #excludeusers = ['Serious', 'User']

        # your nickname for use in admin functions
        # You can also specify nick@hostmask
        # For example: code@unaffiliated/code
        owner = 'yournickname'

        # These are people who will be able to use admin.py's functions...
        admins = [owner, 'someoneyoutrust']

        # website to show for help documentation
        #website = 'http://code.liamstanley.net'

        # would you like color/bolc/italic coded commands? this enables/disables
        # code.color/bold/italic() or any other form of carot notation applied directly by code
        # although, if your module uses raw carot notation, then it won't disable that
        textstyles = True

        # But admin.py is disabled by default, as follows:
        exclude = ['admin', 'admin_channel', 'twss']

        # If you want to enumerate a list of modules rather than disabling
        # some, use "enable = ['example']", which takes precedent over exclude
        #enable = []

        # Block modules from specific channels
        # To not block anything for a channel, just don't mention it
        excludes = {
           '##blacklist': ['!'],
        }

        # This allows one to allow specific people to use ".msg channel message here"
        # in specific channels.
        helpers = {
           '#channel1': ['a.somedomain.tld', 'b.anotherdomain.tld'],
           '##channel2': ['some/other/hostmask'],
        }
            
        # Channel code will report all private messages sent to him to.
        # This includes server notices.
        #logchan_pm = '#code-log'

        # Enable raw logging of everything code sees.
        # logged to the folder 'log'
        logging = False

        # Directories to load user modules from
        # e.g. /path/to/my/modules
        extra = ['""" + os.getcwd() + '/modules/' + """']

        # Only uncomment below if you use oblique.py from the unloaded file
        # Services to load: maps channel names to white or black lists
        # external = {
        #   '#liberal': ['!'], # allow all
        #   '#conservative': [], # allow none
        #   '*': ['!'] # default whitelist, allow all
        #}

        # EOF
        """
    print >> f, trim(output)
    f.close()

def create_configfile(dotdir):

    if not os.path.isdir(dotdir):
        print 'Creating a config in directory ~/.code...'
        try: os.mkdir(dotdir)
        except Exception, e:
            print >> sys.stderr, 'There was a problem creating %s:' % dotdir
            print >> sys.stderr, e.__class__, str(e)
            print >> sys.stderr, 'Please fix this and then run code again.'
            sys.exit(1)

    create_default_config(configpath)
    print >> sys.stdout, 'Config file generated. Please edit it at ' + configpath + ' and run ./code again.'

    sys.exit(0)

def check_dotdir():
    if not os.path.isdir(dotdir) or not os.path.isfile(configpath):
        create_configfile(dotdir)

def config_names(config):
    config = config or 'default'

    def files(d):
        names = os.listdir(d)
        return list(os.path.join(d, fn) for fn in names if fn.endswith('.py'))

    here = os.path.join('.', config)
    if os.path.isfile(here):
        return [here]
    if os.path.isfile(here + '.py'):
        return [here + '.py']
    if os.path.isdir(here):
        return files(here)

    there = os.path.join(dotdir, config)
    if os.path.isfile(there):
        return [there]
    if os.path.isfile(there + '.py'):
        return [there + '.py']
    if os.path.isdir(there):
        return files(there)

    sys.exit(1)

def main(argv=None):
    # Step One: Parse The Command Line

    parser = optparse.OptionParser('%prog [options]')
    parser.add_option('-c', '--config', metavar='fn',
        help='use this configuration file or directory')
    opts, args = parser.parse_args(argv)

    # Step Two: Check Dependencies

    check_python_version() # require python2.4 or later
    check_dotdir() # require ~/.code, or make it and exit

    # Step Three: Load The Configurations

    config_modules = []
    for config_name in config_names(opts.config):
        name = os.path.basename(config_name).split('.')[0] + '_config'
        module = imp.load_source(name, config_name)
        module.filename = config_name

        if not hasattr(module, 'prefix'):
            module.prefix = (r'\.')

        if not hasattr(module, 'name'): 
           module.name = '\x0307Python IRC Bot - http://code.liamstanley.net'

        if not hasattr(module, 'port'):
            module.port = 6667

        if not hasattr(module, 'password'):
            module.password = None

        if module.host == 'irc.example.net':
            error = ('Error: you must edit the config file first!\n' +
                        "You're currently using %s" % module.filename)
            print >> sys.stderr, error
            sys.exit(1)

        config_modules.append(module)

    # Step Four: Load code

    try: from __init__ import run
    except ImportError:
        try: from code import run
        except ImportError:
            print >> sys.stderr, "Error: Couldn't find code to import"
            sys.exit(1)

    # Step Five: Initialise And Run The codees

    # @@ ignore SIGHUP
    for config_module in config_modules:
        run(config_module) # @@ thread this

if __name__ == '__main__':
    main()
