#!/usr/bin/env python
"""
Code Copyright (C) 2012-2013 Liam Stanley
Credits: Sean B. Palmer, Michael Yanovich
quote.py - Code Quote Module
http://code.liamstanley.net/
"""

import random
import json
import os

adds = 'Syntax: \'.addquote <username> <quote>\''
deletes = 'Syntax: \'.delquote <username> [#]\''
reads = 'Syntax: \'.quote [username] [#]\''

def addquote(code, input):
    '''.addquote <nick> something they said here -- adds the quote to the quote
       database. Note, the nick field, is the part where you retrieve them.'''
    if not input.group(2):
        return code.say(adds)
    if len(input.group(2).strip().split()) < 2:
        return code.say(adds)
    data = input.group(2).strip().split()
    #try:
    username, index = add(data[0], data[1::])
    #except:
        #return code.say(adds)
    return code.say('Quote #%s from %s added' % (code.color('blue',str(index)),code.color('green',username)))
addquote.commands = ['addquote']
addquote.priority = 'low'
addquote.example = '.addquote Herpderp I like trains!'
addquote.rate = 30


def add(username,quote):
    if not os.path.isfile('quote.db'):
        create()

    # Make some double checks
    username = username.replace('@','').replace('+','').replace('<','')
    username = username.replace('>','').replace('(','').replace('(','').strip()

    #if len(username) < 1 or len(quote) < 5:
    #    return False
    with open('quote.db', 'r') as file:
        quotes = json.loads(file.read())

    with open('quote.db', 'w') as file:
        if not username in quotes:
            quotes[username.lower()] = []
        quotes[username].append(quote)
        index = quotes[username].index(quote)
        file.write(json.dumps(quotes, indent=4))
    return username, index

def create():
    # Create empty quote database
    quotes = {}
    with open('quote.db','w') as file:
        file.write(json.dumps(quotes, indent=4))
    try:
        # old quotes from old module
        os.remove('quotes.txt')
    except:
        pass

def quote(code, input):
    '''.quote [name] [#] -- displays the corresponding quote'''
    # Check if exists
    if not os.path.isfile('quote.db'):
        create()

    # Load data from quotes database
    try:
        with open('quote.db','r') as file:
            quotes = json.loads(file.read())
    except:
        return code.say(reads)

    if not input.group(2):
        # Fully random, username && quote number

        # Below, we find the random user
        count = 0
        total = len(quotes)
        rand = random.randint(1,total)
        for key in quotes:
            count += 1
            if count == rand:
                user = key
        # Should be 'user'
        # Now we find the random quote
        total = len(quotes[user])
        rand = random.randint(0,total)
        quote = quotes[user][rand]
        return code.say('Quote %s of %s: <%s> %s' % (str(rand),str(total),user,quote))
    elif input.group(2).strip().split() == 1:
        try:
            user = input.group(2).strip().lower()
            total = len(quotes[user])
            rand = random.randint(0,total)
            quote = quotes[user][rand]
            return code.say('Quote %s of %s: <%s> %s' % (str(rand),str(total),user,quote))
        except:
            return code.say('That user doesn\'t exist!')
    elif input.group(2).strip().split() == 2:
        try:
            user = input.group(2).strip().lower().split()[0]
            total = len(quotes[user])
            quote = quotes[user][int(input.group(2).split()[1])]
            return code.say('Quote %s of %s: <%s> %s' % (input.group(2).split()[1],str(total),user,quote))
        except:
            return code.say('That user doesn\'t exist!')
    else:
        return code.say(reads)
quote.commands = ['quote']
quote.priority = 'low'
quote.example = '.quote Herpderp 1'
quote.rate = 30


#def delquote(code, input):
#    '''.rmquote <number> -- removes a given quote from the database. Can only be done by the owner of the bot.'''
#    if not input.admin: return
#    text = input.group(2)
#    number = int()
#    try:
#        fn = open('quotes.txt', 'r')
#    except:
#        return code.reply(code.color('red','No quotes to delete.'))
#    lines = fn.readlines()
#    MAX = len(lines)
#    fn.close()
#    try:
#        number = int(text)
#    except:
#        code.reply('Please enter the quote number you would like to delete.')
#        return
#    newlines = lines[:number-1] + lines[number:]
#    fn = open('quotes.txt', 'w')
#    for line in newlines:
#        txt = uc.encode(line)
#        if txt:
#            fn.write(txt)
#            if txt[-1] != '\n':
#                fn.write('\n')
#    fn.close()
#    code.reply(code.color('green','Successfully deleted quote %s.' % (number)))
#delquote.commands = ['rmquote', 'delquote','deletequote','removequote']
#delquote.priority = 'low'
#delquote.example = '.rmquote'
#delquote.rate = 30

#def delete(username,number=False):
#    if number:
#        # Delete a specific quote
#

if __name__ == '__main__':
    print __doc__.strip()