#
# AnyMeta API: distutils file for distributing the library
#
# (c)2008 Arjan Scherpenisse <arjan@mediamatic.nl>
#
#
# The MIT License
#
# Copyright (c) 2007-2008 Mediamatic Lab
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
#

from setuptools import setup

from anymeta import __version__

setup(name='AnyMetaAPI',
      version=__version__,
      description="Support library for accessing AnyMeta-based websites from Python.",
      long_description=open("README", "r").read(),
      author='Arjan Scherpenisse',
      author_email='arjan@mediamatic.nl',
      maintainer_email='arjan@mediamatic.nl',
      platforms='any',
      url='http://trac.mediamatic.nl/python-anymeta',
      keywords="anymeta mediamatic api web2.0 social network oauth",
      license='MIT',
      classifiers=["Development Status :: 3 - Alpha",
                   "Intended Audience :: Developers",
                   "License :: OSI Approved :: MIT License",
                   "Programming Language :: Python",
                   "Topic :: Software Development :: Libraries :: Python Modules",
                   ],
      packages=['anymeta',
                'anymeta.api',
                'anymeta.api.oauth',
		'anymeta.availability',
		'anymeta.gtk',
                'anymeta.xmpp',
                'twisted.plugins'
                ],
      package_data={'twisted.plugins': ['twisted/plugins/anyxmpp.py'],
                    '': ['*.glade']},
      install_requires = [
      'pydataportability.xrds>=0.2',
      'simplejson'
      ],
      entry_points = {'console_scripts': ['any-registry = anymeta.api.cli:main']}
      )
