#!/usr/bin/env python

from setuptools import setup
from distutils.core import Command
from unittest import TextTestRunner
import copy
import os
import sys

package_dir = "lib"
script_dir = "scripts"


with open('README.txt') as file:
    long_description = file.read()

setup(name='ActivePapers.Py',
      version='0.1',
      description='Executable papers containing Python code',
      long_description=long_description,
      author='Konrad Hinsen',
      author_email='research@khinsen.fastmail.net',
      url='https://bitbucket.org/khinsen/active_papers_py',
      license='BSD',
      package_dir = {'': package_dir},
      packages=['activepapers'],
      scripts=[os.path.join(script_dir, s) for s in os.listdir(script_dir)],
      platforms=['any'],
      requires=["numpy (>=1.6)", "h5py (>=2.1)", "tempdir (>=0.5)"],
      provides=["activepapers"],
      classifiers=[
          "Development Status :: 3 - Alpha",
          "Intended Audience :: Science/Research",
          "License :: OSI Approved :: BSD License",
          "Operating System :: OS Independent",
          "Programming Language :: Python :: 2.7",
          "Programming Language :: Python :: 3.2",
          "Programming Language :: Python :: 3.3",
          "Topic :: Scientific/Engineering",
      ]
  )
