#!/usr/bin/env python

import glob
import os
import shutil
import tempfile

import session
import test

class pysession(session.session):
    def __init__(self, test, include = [], log = None):
        # Prep a temporary working directory.
        _pop = os.getcwd()
        src = os.path.dirname(test)
        dst = tempfile.mkdtemp()
        search = os.path.join(src, os.path.splitext(os.path.basename(test))[0])
        for file in glob.glob(search + '*'):
            shutil.copy(
              os.path.join(src, file),
              os.path.join(dst, os.path.basename(file)))
        self._args = [os.path.join(dst, os.path.basename(test))]
        os.chdir(dst)
        self._input = None
        env = os.environ
        env['PYTHONPATH'] = ':'.join(include)
        session.session.__init__(self, executable = 'python', log = log)
        shutil.rmtree(dst)
        os.chdir(_pop)

class pytest(test.test):
    def _create(self):
        return pysession(
          test = self._path,
          include = self._include,
          log = self._log)

    def _checksuccess(self):
        if 'stdout' in self._results:
            if self._results['stdout'] == []:
                # One extra line generated by exiting Python.
                self._results['stdout'] += ['']
        if 'stdout' in self._expects:
            self._expects['stdout'] += ['']

        return test.test._checksuccess(self)
