import slumber
import urllib2


def _field_schema(base_url, plural):
    url = base_url + plural + "/schema/"
    json = slumber.serialize.JsonSerializer()
    
    response = urllib2.urlopen(url)
    html = response.read()
    return lambda: json.loads(html)
    
def _list_field(api, plural):
    return lambda **kwargs: getattr(api, plural).get(**kwargs)

def _create_field(api, plural):
    return lambda info_dict: getattr(api, plural).post(info_dict)

def _get_field(api, plural):
    return lambda id: getattr(api, plural).__call__(id).get()

def _update_field(api, plural):
    return lambda id, info_dict: getattr(api, plural).__call__(id).put(info_dict)

class CharityAPI():
    
    def __init__(self, api_token=None,
                 version="v1", api_location="http://cnapi.tivixlabs.com/api/"):
        
        if api_token:
            raise Error("This has not been implemented yet")
        self.base_url = api_location + version + "/"
        self.api = slumber.API(self.base_url)
        
        #dynamically generate our api functions
        fields = {
            "category": "categories",
            "cause": "causes",
            "celebrity": "celebrities",
            "organization": "organizations",
            "celebrity_relationship": "celebrity_relationships",
            "celebrity_org": "celebrity_orgs",
            "country_region": "country_regions",
            "country": "countries",
            "country_org": "country_orgs",
            "orgs_rating": "orgs_ratings",
        }
        for single, plural in fields.items():
            setattr(self, single + '_schema', _field_schema(self.base_url, plural))
            
            setattr(self, "list_" + plural, _list_field(self.api, plural))
            
#            setattr(self, "create_" + single, _create_field(self.api, plural))
                
            setattr(self, "get_" + single, _get_field(self.api, plural))
            
#            setattr(self, "update_" + single, _update_field(self.api, plural))
            
            #delete is not allowed but would go like this
#            def delete_field(id):
#                return getattr(self.api, plural).__call__(id).delete()
#            setattr(self, "delete_" + single, get_field)