package Bencher::Scenario::ListUtil;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.03'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark List::Util (XS) vs PP implementation(s)',

    description => <<'_',

EARLY VERSION, ONLY A FEW FUNCTIONS HAVE BEEN BENCHMARKED.

For max*/min*, in general the XS version are about 3x faster than PP.

_

    participants => [
        # max
        {
            tags => ['numeric'],
            fcall_template => 'List::Util::max(@{<list>})',
        },
        {
            tags => ['numeric'],
            fcall_template => 'PERLANCAR::List::Util::PP::max(@{<list>})',
        },
        # maxstr
        {
            tags => ['stringy'],
            fcall_template => 'List::Util::maxstr(@{<list>})',
        },
        {
            tags => ['stringy'],
            fcall_template => 'PERLANCAR::List::Util::PP::maxstr(@{<list>})',
        },

        # min
        {
            tags => ['numeric'],
            fcall_template => 'List::Util::min(@{<list>})',
        },
        {
            tags => ['numeric'],
            fcall_template => 'PERLANCAR::List::Util::PP::min(@{<list>})',
        },
        # minstr
        {
            tags => ['stringy'],
            fcall_template => 'List::Util::minstr(@{<list>})',
        },
        {
            tags => ['stringy'],
            fcall_template => 'PERLANCAR::List::Util::PP::minstr(@{<list>})',
        },

    ],

    datasets => [
        {
            name => 'num10',
            args => {
                list => [2..5, 1,10, 6..9],
            },
        },
        {
            name => 'num100',
            args => {
                list => [2..50, 1,100, 51..99],
            },
        },
        {
            name => 'num1000',
            args => {
                list => [2..500, 1,1000, 501..999],
            },
        },

        {
            name => 'str10',
            args => {
                list => ['b'..'e', 'a','j', 'f'..'i'],
            },
            exclude_participant_tags => ['numeric'],
        },
        {
            name => 'str100', # aa..dv
            args => {
                list => ['ab'..'bx', 'aa','dv', 'by'..'du'],
            },
            exclude_participant_tags => ['numeric'],
        },
        {
            name => 'str1000', # aaa..bml
            args => {
                list => ['aab'..'atf', 'aaa','bml', 'atg'..'bmk'],
            },
            exclude_participant_tags => ['numeric'],
        },
    ],
};

1;
# ABSTRACT: Benchmark List::Util (XS) vs PP implementation(s)

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ListUtil

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::ListUtil (from Perl distribution Bencher-Scenario-ListUtil), released on 2016-01-05.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ListUtil

To run module startup overhead benchmark:

 % bencher --module-startup -m ListUtil

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

L<List::Util> 1.41

L<PERLANCAR::List::Util::PP> 0.04

=head1 BENCHMARK PARTICIPANTS

=over

=item * List::Util::max (perl_code)

Function call template:

 List::Util::max(@{<list>})



=item * PERLANCAR::List::Util::PP::max (perl_code)

Function call template:

 PERLANCAR::List::Util::PP::max(@{<list>})



=item * List::Util::maxstr (perl_code)

Function call template:

 List::Util::maxstr(@{<list>})



=item * PERLANCAR::List::Util::PP::maxstr (perl_code)

Function call template:

 PERLANCAR::List::Util::PP::maxstr(@{<list>})



=item * List::Util::min (perl_code)

Function call template:

 List::Util::min(@{<list>})



=item * PERLANCAR::List::Util::PP::min (perl_code)

Function call template:

 PERLANCAR::List::Util::PP::min(@{<list>})



=item * List::Util::minstr (perl_code)

Function call template:

 List::Util::minstr(@{<list>})



=item * PERLANCAR::List::Util::PP::minstr (perl_code)

Function call template:

 PERLANCAR::List::Util::PP::minstr(@{<list>})



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+-----------------------------------------------------------------------+------------+------------+---------+---------+
 | seq | name                                                                  | rate       | time       | errors  | samples |
 +-----+-----------------------------------------------------------------------+------------+------------+---------+---------+
 | 14  | {dataset=>"num1000",participant=>"PERLANCAR::List::Util::PP::maxstr"} | 4.07e+03   | 246μs      | 4.6e-07 | 22      |
 | 32  | {dataset=>"num1000",participant=>"PERLANCAR::List::Util::PP::minstr"} | 4.21e+03   | 238μs      | 4.1e-07 | 22      |
 | 17  | {dataset=>"str1000",participant=>"PERLANCAR::List::Util::PP::maxstr"} | 5247.809   | 190.5557μs | 4.5e-11 | 20      |
 | 35  | {dataset=>"str1000",participant=>"PERLANCAR::List::Util::PP::minstr"} | 6.13e+03   | 163μs      | 2.1e-07 | 20      |
 | 26  | {dataset=>"num1000",participant=>"List::Util::minstr"}                | 7.27e+03   | 138μs      | 2.6e-07 | 21      |
 | 8   | {dataset=>"num1000",participant=>"List::Util::maxstr"}                | 7436.7     | 134.468μs  | 4.6e-11 | 25      |
 | 5   | {dataset=>"num1000",participant=>"PERLANCAR::List::Util::PP::max"}    | 7821.54    | 127.852μs  | 4.6e-11 | 20      |
 | 23  | {dataset=>"num1000",participant=>"PERLANCAR::List::Util::PP::min"}    | 8.53e+03   | 117μs      | 2.1e-07 | 20      |
 | 11  | {dataset=>"str1000",participant=>"List::Util::maxstr"}                | 1.43e+04   | 69.9μs     | 2.3e-08 | 26      |
 | 29  | {dataset=>"str1000",participant=>"List::Util::minstr"}                | 1.44e+04   | 69.2μs     | 1e-07   | 21      |
 | 20  | {dataset=>"num1000",participant=>"List::Util::min"}                   | 3.43e+04   | 29.1μs     | 5.2e-08 | 21      |
 | 2   | {dataset=>"num1000",participant=>"List::Util::max"}                   | 3.56e+04   | 28.1μs     | 5.3e-08 | 20      |
 | 13  | {dataset=>"num100",participant=>"PERLANCAR::List::Util::PP::maxstr"}  | 42844      | 23.341μs   | 1e-10   | 20      |
 | 31  | {dataset=>"num100",participant=>"PERLANCAR::List::Util::PP::minstr"}  | 4.47e+04   | 22.4μs     | 2.7e-08 | 20      |
 | 16  | {dataset=>"str100",participant=>"PERLANCAR::List::Util::PP::maxstr"}  | 5.108e+04  | 19.58μs    | 6.1e-09 | 24      |
 | 34  | {dataset=>"str100",participant=>"PERLANCAR::List::Util::PP::minstr"}  | 5.94e+04   | 16.8μs     | 6.7e-09 | 20      |
 | 4   | {dataset=>"num100",participant=>"PERLANCAR::List::Util::PP::max"}     | 7.48e+04   | 13.4μs     | 2.7e-08 | 20      |
 | 25  | {dataset=>"num100",participant=>"List::Util::minstr"}                 | 8e+04      | 13μs       | 5.7e-08 | 20      |
 | 22  | {dataset=>"num100",participant=>"PERLANCAR::List::Util::PP::min"}     | 82282      | 12.153μs   | 1.5e-10 | 20      |
 | 7   | {dataset=>"num100",participant=>"List::Util::maxstr"}                 | 84207      | 11.875μs   | 4.7e-11 | 20      |
 | 10  | {dataset=>"str100",participant=>"List::Util::maxstr"}                 | 140994     | 7.09251μs  | 1.1e-11 | 20      |
 | 28  | {dataset=>"str100",participant=>"List::Util::minstr"}                 | 1.4183e+05 | 7.0507μs   | 4.7e-11 | 20      |
 | 12  | {dataset=>"num10",participant=>"PERLANCAR::List::Util::PP::maxstr"}   | 3.15e+05   | 3.17μs     | 1.7e-09 | 20      |
 | 19  | {dataset=>"num100",participant=>"List::Util::min"}                    | 3.39e+05   | 2.95μs     | 3.3e-09 | 20      |
 | 1   | {dataset=>"num100",participant=>"List::Util::max"}                    | 3.42e+05   | 2.92μs     | 3e-09   | 24      |
 | 30  | {dataset=>"num10",participant=>"PERLANCAR::List::Util::PP::minstr"}   | 3.642e+05  | 2.746μs    | 8.3e-10 | 20      |
 | 15  | {dataset=>"str10",participant=>"PERLANCAR::List::Util::PP::maxstr"}   | 4.11e+05   | 2.44μs     | 3.3e-09 | 20      |
 | 33  | {dataset=>"str10",participant=>"PERLANCAR::List::Util::PP::minstr"}   | 4.4282e+05 | 2.2583μs   | 1.1e-11 | 20      |
 | 3   | {dataset=>"num10",participant=>"PERLANCAR::List::Util::PP::max"}      | 5.3e+05    | 1.89μs     | 7.9e-10 | 24      |
 | 21  | {dataset=>"num10",participant=>"PERLANCAR::List::Util::PP::min"}      | 5.6e+05    | 1.8μs      | 7.1e-09 | 22      |
 | 24  | {dataset=>"num10",participant=>"List::Util::minstr"}                  | 6.74e+05   | 1.48μs     | 2.1e-09 | 20      |
 | 6   | {dataset=>"num10",participant=>"List::Util::maxstr"}                  | 7.079e+05  | 1.413μs    | 4.4e-10 | 20      |
 | 27  | {dataset=>"str10",participant=>"List::Util::minstr"}                  | 1.12e+06   | 0.893μs    | 1.7e-09 | 20      |
 | 9   | {dataset=>"str10",participant=>"List::Util::maxstr"}                  | 1.14e+06   | 0.875μs    | 1.7e-09 | 20      |
 | 18  | {dataset=>"num10",participant=>"List::Util::min"}                     | 1.99e+06   | 0.504μs    | 8.3e-10 | 20      |
 | 0   | {dataset=>"num10",participant=>"List::Util::max"}                     | 2.06e+06   | 0.486μs    | 8.6e-10 | 20      |
 +-----+-----------------------------------------------------------------------+------------+------------+---------+---------+


Benchmark module startup overhead:

 +-----+---------------------------+--------+-------------------+---------+---------+
 | seq | name                      | time   | mod_overhead_time | errors  | samples |
 +-----+---------------------------+--------+-------------------+---------+---------+
 | 2   | PERLANCAR::List::Util::PP | 8.31ms | 3.47ms            | 1.5e-05 | 21      |
 | 1   | List::Util                | 7ms    | 2.1ms             | 4.8e-05 | 20      |
 | 0   | perl -e1 (baseline)       | 4.8ms  | 0ms               | 3.9e-05 | 20      |
 +-----+---------------------------+--------+-------------------+---------+---------+

=head1 DESCRIPTION

EARLY VERSION, ONLY A FEW FUNCTIONS HAVE BEEN BENCHMARKED.

For max*/min*, in general the XS version are about 3x faster than PP.


Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-ListUtil>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-ListUtil>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-ListUtil>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
